/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.gen.parser.parameter.analysis.DepthFirstAdapter;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.AAlphanumericParamToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.AAnySequenceParamToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.AEscapeSequenceParamToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.ALiteral;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.AReference;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.AVariable;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.LiteralToken;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.core.utils.SemanticParsingException;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedParameter
extends DepthFirstAdapter {
    private List<IParamValueToken> m_paramValueTokens = new ArrayList<IParamValueToken>();
    private boolean m_isGuiSource;
    private IParameterInterfacePO m_paramNode;
    private IParamDescriptionPO m_paramDesc;

    public ParsedParameter(boolean isGuiSource, IParameterInterfacePO paramNode, IParamDescriptionPO desc) {
        this.m_isGuiSource = isGuiSource;
        this.m_paramNode = paramNode;
        this.m_paramDesc = desc;
    }

    @Override
    public void caseALiteral(ALiteral literal) {
        super.caseALiteral(literal);
        StringBuilder literalBuilder = new StringBuilder();
        literalBuilder.append(literal.getOpenLiteral().getText());
        if (literal.getLiteralBody() != null) {
            literalBuilder.append(literal.getLiteralBody().getText());
        }
        literalBuilder.append(literal.getCloseLiteral().getText());
        this.m_paramValueTokens.add(new LiteralToken(literalBuilder.toString(), literal.getOpenLiteral().getPos()));
    }

    @Override
    public void caseAEscapeSequenceParamToken(AEscapeSequenceParamToken escSeq) {
        super.caseAEscapeSequenceParamToken(escSeq);
        this.m_paramValueTokens.add(new SimpleValueToken(escSeq.getEscapedSymbol().getText(), escSeq.getEscapedSymbol().getPos(), this.m_paramDesc));
    }

    @Override
    public void caseAReference(AReference ref) {
        super.caseAReference(ref);
        boolean containsBraces = ref.getOpenBrace() != null;
        StringBuilder refBuilder = new StringBuilder(ref.getReferenceToken().getText());
        if (containsBraces) {
            refBuilder.append(ref.getOpenBrace().getText());
        }
        if (ref.getReferenceBody() == null) {
            if (containsBraces && ref.getCloseBrace() != null) {
                throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_MISSING_CONTENT)), MessageIDs.E_MISSING_CONTENT, ref.getReferenceToken().getPos());
            }
            throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_ONE_CHAR_PARSE_ERROR)), MessageIDs.E_ONE_CHAR_PARSE_ERROR, ref.getReferenceToken().getPos());
        }
        refBuilder.append(ref.getReferenceBody().getText());
        if (ref.getCloseBrace() != null) {
            if (!containsBraces) {
                throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_GENERAL_PARSE_ERROR)), MessageIDs.E_GENERAL_PARSE_ERROR, ref.getCloseBrace().getPos());
            }
            refBuilder.append(ref.getCloseBrace().getText());
        } else if (containsBraces) {
            throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_MISSING_CLOSING_BRACE)), MessageIDs.E_MISSING_CLOSING_BRACE, ref.getOpenBrace().getPos());
        }
        this.m_paramValueTokens.add(new RefToken(refBuilder.toString(), this.m_isGuiSource, ref.getReferenceToken().getPos(), this.m_paramNode, this.m_paramDesc));
    }

    @Override
    public void caseAVariable(AVariable var) {
        super.caseAVariable(var);
        boolean containsBraces = var.getOpenBrace() != null;
        String variableBody = var.getVariableBody() != null ? var.getVariableBody().getText() : "";
        StringBuilder varBuilder = new StringBuilder(var.getVariableToken().getText());
        if (containsBraces) {
            varBuilder.append(var.getOpenBrace().getText());
        }
        if (StringUtils.isEmpty((String)variableBody)) {
            if (containsBraces && var.getCloseBrace() != null) {
                throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_MISSING_CONTENT)), MessageIDs.E_MISSING_CONTENT, var.getVariableToken().getPos());
            }
            throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_ONE_CHAR_PARSE_ERROR)), MessageIDs.E_ONE_CHAR_PARSE_ERROR, var.getVariableToken().getPos());
        }
        varBuilder.append(variableBody);
        if (var.getCloseBrace() != null) {
            if (!containsBraces) {
                throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_GENERAL_PARSE_ERROR)), MessageIDs.E_GENERAL_PARSE_ERROR, var.getCloseBrace().getPos());
            }
            varBuilder.append(var.getCloseBrace().getText());
        } else if (containsBraces) {
            throw new SemanticParsingException(I18n.getString((String)MessageIDs.getMessage((Integer)MessageIDs.E_MISSING_CLOSING_BRACE)), MessageIDs.E_MISSING_CLOSING_BRACE, var.getOpenBrace().getPos());
        }
        this.m_paramValueTokens.add(new VariableToken(varBuilder.toString(), var.getVariableToken().getPos(), variableBody, this.m_paramDesc));
    }

    @Override
    public void caseAAlphanumericParamToken(AAlphanumericParamToken alphanumeric) {
        super.caseAAlphanumericParamToken(alphanumeric);
        this.m_paramValueTokens.add(new SimpleValueToken(alphanumeric.getAlphanumeric().getText(), alphanumeric.getAlphanumeric().getPos(), this.m_paramDesc));
    }

    @Override
    public void caseAAnySequenceParamToken(AAnySequenceParamToken anySeq) {
        super.caseAAnySequenceParamToken(anySeq);
        this.m_paramValueTokens.add(new SimpleValueToken(anySeq.getChar().getText(), anySeq.getChar().getPos(), this.m_paramDesc));
    }

    public List<IParamValueToken> getTokens() {
        return this.m_paramValueTokens;
    }
}

