/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleValueToken
implements IParamValueToken {
    private static final String VARIABLE = "guidancer.datatype.Variable";
    private String m_value = null;
    private int m_startPos = 0;
    private Integer m_errorKey;
    private IParamDescriptionPO m_desc;

    public SimpleValueToken(String s, int pos, IParamDescriptionPO desc) {
        this.m_value = s;
        this.m_startPos = pos;
        this.m_desc = desc;
    }

    @Override
    public ParamValueConverter.ConvValidationState validate() {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.notSet;
        if (VARIABLE.equals(this.m_desc.getType())) {
            if (Pattern.matches("[0-9a-z_A-Z]{1,}", this.m_value)) {
                state = ParamValueConverter.ConvValidationState.valid;
            } else {
                state = ParamValueConverter.ConvValidationState.invalid;
                this.setErrorKey(MessageIDs.E_PARSE_NAME_ERROR);
            }
        }
        return state;
    }

    @Override
    public boolean isI18Nrelevant() {
        return true;
    }

    @Override
    public Integer getErrorKey() {
        return this.m_errorKey;
    }

    @Override
    public int getEndIndex() {
        return this.m_startPos + this.m_value.length();
    }

    @Override
    public int getStartIndex() {
        return this.m_startPos;
    }

    @Override
    public String getGuiString() {
        return this.m_value;
    }

    @Override
    public String getExecutionString(List<ExecObject> stack, Locale locale) throws InvalidDataException {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        do {
            char c;
            if ((c = this.m_value.charAt(index)) == '\\') {
                if (index + 1 < this.m_value.length()) {
                    c = this.m_value.charAt(++index);
                    char[] validChars = new char[]{'\\', '=', '{', '}', '$', '\''};
                    boolean isValid = false;
                    char[] cArray = validChars;
                    int n = validChars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char validChar = cArray[n2];
                        if (validChar == c) {
                            builder.append(c);
                            isValid = true;
                            ++index;
                            break;
                        }
                        ++n2;
                    }
                    if (isValid) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append(Messages.InvalidCharacter);
                    msg.append(" ");
                    msg.append(c);
                    msg.append(" ");
                    msg.append(Messages.AfterBackslashIn);
                    msg.append(" ");
                    msg.append(this.m_value);
                    throw new InvalidDataException(msg.toString(), MessageIDs.E_SYNTAX_ERROR);
                }
                throw new InvalidDataException(String.valueOf(Messages.NotAllowedToSetSingleBackslashIn) + " " + this.m_value, MessageIDs.E_SYNTAX_ERROR);
            }
            builder.append(c);
            ++index;
        } while (index < this.m_value.length());
        return builder.toString();
    }

    @Override
    public String getModelString() {
        return this.m_value;
    }

    @Override
    public void setErrorKey(Integer errorKey) {
        this.m_errorKey = errorKey;
    }
}

