/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.inspector.ui.i18n.Messages;
import org.eclipse.jubula.client.inspector.ui.model.InspectedComponent;
import org.eclipse.jubula.client.inspector.ui.provider.sourceprovider.InspectorStateProvider;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.InspectorComponentSelectedMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class InspectorComponentSelectedCommand
implements ICommand {
    private static Log log = LogFactory.getLog(InspectorComponentSelectedCommand.class);
    private InspectorComponentSelectedMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (InspectorComponentSelectedMessage)message;
    }

    public Message execute() {
        IWorkbenchWindow[] windows;
        try {
            AUTConnection.getInstance().close();
        }
        catch (ConnectionException ce) {
            log.info((Object)(String.valueOf(Messages.AttemptedCloseUninitializedConnection) + "."), (Throwable)ce);
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            activeWorkbenchWindow = windows[0];
            final Shell shell = activeWorkbenchWindow.getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    shell.getShell().setMinimized(false);
                    shell.setActive();
                }
            });
        }
        InspectedComponent.getInstance().setCompId(this.m_message.getComponentIdentifier());
        ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        InspectorStateProvider sourceProvider = (InspectorStateProvider)service.getSourceProvider("org.eclipse.jubula.client.inspector.ui.variable.isInspectorActive");
        sourceProvider.setInspectorActive(false);
        return null;
    }

    public void timeout() {
        log.error((Object)(String.valueOf(this.getClass().getName()) + Messages.TimeoutCalled));
    }
}

