/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.IAUTEventListener;
import org.eclipse.jubula.client.core.commands.AUTHighlightComponentCommand;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.AbstractAction;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTHighlightComponentMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class OMMarkInAutAction
extends AbstractAction
implements IAUTEventListener {
    private static IAction handleAction;

    public void init(IAction action) {
        handleAction = action;
        handleAction.setEnabled(true);
    }

    public void runWithEvent(IAction action, Event event) {
        ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)Plugin.getActivePart();
        ISelection sel = editor.getSite().getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sSel = (IStructuredSelection)sel;
        if (AUTModeChangedCommand.getAutMode() == 2 && sSel.size() == 1 && sSel.getFirstElement() instanceof IObjectMappingAssoziationPO) {
            ICompIdentifierPO assoCompId = ((IObjectMappingAssoziationPO)sSel.getFirstElement()).getTechnicalName();
            ComponentIdentifier compId = new ComponentIdentifier();
            if (assoCompId != null) {
                compId.setComponentClassName(assoCompId.getComponentClassName());
                compId.setHierarchyNames(new ArrayList(assoCompId.getHierarchyNames()));
                compId.setNeighbours(new ArrayList(assoCompId.getNeighbours()));
                compId.setSupportedClassName(assoCompId.getSupportedClassName());
                compId.setAlternativeDisplayName(assoCompId.getAlternativeDisplayName());
            }
            AUTHighlightComponentCommand response = new AUTHighlightComponentCommand((IAUTEventListener)this);
            try {
                AUTHighlightComponentMessage message = new AUTHighlightComponentMessage();
                message.setComponent((IComponentIdentifier)compId);
                AUTConnection.getInstance().request((Message)message, (ICommand)response, 5000);
            }
            catch (BaseConnection.NotConnectedException notConnectedException) {
            }
            catch (CommunicationException communicationException) {}
        }
    }

    public static IAction getAction() {
        return handleAction;
    }

    public static void setEnabled(boolean enabled) {
        handleAction.setEnabled(enabled);
    }

    public void stateChanged(AUTEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Utils.createMessageDialog(new JBException(Messages.ComponentCouldNotBeFoundInRunningAut, MessageIDs.E_COMPONENT_NOT_FOUND), null, null);
            }
        });
    }
}

