/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.AbstractAction;
import org.eclipse.jubula.client.ui.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

public class OMSetCategoryToMapInto
extends AbstractAction {
    private static IAction handleAction;

    public void init(IAction action) {
        handleAction = action;
        handleAction.setEnabled(true);
    }

    public void runWithEvent(IAction action, Event event) {
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel instanceof IStructuredSelection) {
            this.setCategoryToMapInto((IStructuredSelection)sel);
        }
    }

    private void setCategoryToMapInto(IStructuredSelection selection) {
        ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)Plugin.getActivePart();
        if (editor.getAut().equals(TestExecution.getInstance().getConnectedAut())) {
            IObjectMappingCategoryPO category = null;
            if (selection.size() == 1) {
                String strCat;
                IObjectMappingAssoziationPO assocNode;
                Object node = selection.getFirstElement();
                IObjectMappingCategoryPO unmappedTechNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
                if (node instanceof IObjectMappingCategoryPO) {
                    IObjectMappingCategoryPO catNode = (IObjectMappingCategoryPO)node;
                    if (unmappedTechNames.equals(OMEditorDndSupport.getSection(catNode))) {
                        category = catNode;
                    }
                } else if (node instanceof IObjectMappingAssoziationPO && unmappedTechNames.equals(OMEditorDndSupport.getSection(assocNode = (IObjectMappingAssoziationPO)node))) {
                    category = assocNode.getCategory();
                }
                editor.getOmEditorBP().setCategoryToCreateIn(category);
                IObjectMappingCategoryPO cat = ObjectMappingEventDispatcher.getCategoryToCreateIn();
                if (cat != null) {
                    strCat = cat.getName();
                    if (OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat) != null) {
                        strCat = OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat);
                    }
                } else {
                    strCat = Messages.TestExecutionContributorCatUnassigned;
                }
                String message = NLS.bind((String)Messages.TestExecutionContributorAUTStartedMapping, (Object[])new Object[]{strCat});
                Plugin.showStatusLine(5, message);
            }
        }
    }

    public static IAction getAction() {
        return handleAction;
    }

    public static void setEnabled(boolean enabled) {
        handleAction.setEnabled(enabled);
    }
}

