/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEditorBP {
    private transient IObjectMappingCategoryPO m_categoryToCreateIn;
    private ObjectMappingMultiPageEditor m_editor;

    public OMEditorBP(ObjectMappingMultiPageEditor editor) {
        this.setEditor(editor);
    }

    public IObjectMappingCategoryPO getCategoryToCreateIn() {
        return this.m_categoryToCreateIn;
    }

    public void setCategoryToCreateIn(IObjectMappingCategoryPO categoryToCreateIn) {
        this.m_categoryToCreateIn = categoryToCreateIn;
        ObjectMappingEventDispatcher.setCategoryToCreateIn((IObjectMappingCategoryPO)categoryToCreateIn);
    }

    public IObjectMappingCategoryPO deleteCategory(IObjectMappingCategoryPO toDelete) {
        IObjectMappingCategoryPO parent = toDelete.getParent();
        parent.removeCategory(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)toDelete, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    public IObjectMappingCategoryPO deleteCompName(IComponentNamePO toDelete) {
        IObjectMappingCategoryPO originalCategory = null;
        IWritableComponentNameMapper compNameMapper = this.getEditor().getEditorHelper().getEditSupport().getCompMapper();
        IObjectMappingAssoziationPO parent = this.getAssociation(toDelete.getGuid());
        try {
            IObjectMappingCategoryPO category;
            compNameMapper.changeReuse((IComponentNameReuser)parent, toDelete.getGuid(), null);
            originalCategory = category = parent.getCategory();
            if (parent.getLogicalNames().isEmpty()) {
                originalCategory.removeAssociation(parent);
                if (parent.getTechnicalName() != null) {
                    Stack<String> catPath = new Stack<String>();
                    while (category.getParent() != null) {
                        catPath.push(category.getName());
                        category = category.getParent();
                    }
                    IObjectMappingCategoryPO newCategory = this.getEditor().getAut().getObjMap().getUnmappedTechnicalCategory();
                    while (!catPath.isEmpty()) {
                        String catName = (String)catPath.pop();
                        IObjectMappingCategoryPO subcategory = this.findSubcategory(newCategory, catName);
                        if (subcategory == null) {
                            subcategory = PoMaker.createObjectMappingCategoryPO((String)catName);
                            newCategory.addCategory(subcategory);
                        }
                        newCategory = subcategory;
                    }
                    newCategory.addAssociation(parent);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap().getUnmappedTechnicalCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                } else {
                    this.getEditor().getEditorHelper().getEditSupport().getSession().remove((Object)parent);
                }
            }
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)originalCategory, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
        catch (IncompatibleTypeException ite) {
            Utils.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForEditor(pme, this.getEditor());
        }
        return originalCategory;
    }

    public IObjectMappingCategoryPO deleteAssociation(IObjectMappingAssoziationPO toDelete) {
        IObjectMappingCategoryPO parent = toDelete.getCategory();
        parent.removeAssociation(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    private IObjectMappingCategoryPO findSubcategory(IObjectMappingCategoryPO category, String subcategoryName) {
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            if (!subcategoryName.equals(subcategory.getName())) continue;
            return subcategory;
        }
        return null;
    }

    public IObjectMappingAssoziationPO getAssociation(String compNameGuid) {
        IObjectMappingPO objMap = this.getEditor().getAut().getObjMap();
        return objMap.getLogicalNameAssoc(compNameGuid);
    }

    public boolean existCategory(IObjectMappingCategoryPO start, String name) {
        for (IObjectMappingCategoryPO child : start.getUnmodifiableCategoryList()) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IObjectMappingCategoryPO getSection(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        if (assoc != null) {
            return OMEditorDndSupport.getSection(assoc);
        }
        return null;
    }

    public IObjectMappingCategoryPO getCategory(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        return assoc.getCategory();
    }

    public IObjectMappingCategoryPO createCategory(IObjectMappingCategoryPO section, IObjectMappingCategoryPO subcategory) {
        IObjectMappingCategoryPO curCat = section;
        for (String pathEntry : this.getCatPath(subcategory)) {
            boolean childExists = false;
            for (IObjectMappingCategoryPO child : curCat.getUnmodifiableCategoryList()) {
                if (!child.getName().equals(pathEntry)) continue;
                curCat = child;
                childExists = true;
                break;
            }
            if (childExists) continue;
            IObjectMappingCategoryPO newCat = PoMaker.createObjectMappingCategoryPO((String)pathEntry);
            curCat.addCategory(newCat);
            curCat = newCat;
        }
        return curCat;
    }

    private List<String> getCatPath(IObjectMappingCategoryPO category) {
        ArrayList<String> catPath = new ArrayList<String>();
        IObjectMappingCategoryPO curCat = category;
        while (curCat.getParent() != null) {
            catPath.add(curCat.getName());
            curCat = curCat.getParent();
        }
        Collections.reverse(catPath);
        return catPath;
    }

    public void collectNewLogicalComponentNames() {
        this.getEditor().cleanupNames();
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap().getUnmappedLogicalCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
    }

    private void setEditor(ObjectMappingMultiPageEditor editor) {
        this.m_editor = editor;
    }

    private ObjectMappingMultiPageEditor getEditor() {
        return this.m_editor;
    }
}

