/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ExecTreeTraverser;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.SpecTreeTraverser;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.GDConfigXmlException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidAction;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidComponent;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidParam;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.osgi.util.NLS;

public class ProblemsBP
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.ILanguageChangedListener,
DataEventDispatcher.IServerConnectionListener {
    private static ProblemsBP instance;
    private static Log log;
    private final Set<Integer> m_compNameProblemTypes = new HashSet<Integer>(Arrays.asList(ProblemType.REASON_ACTION_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_COMP_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_DEPRECATED_ACTION.ordinal(), ProblemType.REASON_DEPRECATED_COMP.ordinal(), ProblemType.REASON_NO_COMPTYPE.ordinal(), ProblemType.REASON_PARAM_DOES_NOT_EXIST.ordinal(), ProblemType.REASON_PROJECT_DOES_NOT_EXIST.ordinal()));
    private final Set<Integer> m_missingProjectProblemTypes = new HashSet<Integer>(Arrays.asList(ProblemType.REASON_PROJECT_DOES_NOT_EXIST.ordinal()));
    private List<IMarker> m_markerList = new ArrayList<IMarker>();
    private List<IMarker> m_markerToShowList = new ArrayList<IMarker>();
    private IWorkspaceRoot m_resource = ResourcesPlugin.getWorkspace().getRoot();

    static {
        log = LogFactory.getLog(ProblemsBP.class);
    }

    private ProblemsBP() {
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        DataEventDispatcher.getInstance().addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, true);
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        DataEventDispatcher.getInstance().addServerConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
        this.doProblemsCheck(true, null);
    }

    public static ProblemsBP getInstance() {
        if (instance == null) {
            instance = new ProblemsBP();
        }
        return instance;
    }

    public void handleProjectLoaded() {
        try {
            this.doProblemsCheck(true, null);
        }
        catch (GDConfigXmlException gDConfigXmlException) {}
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.doProblemsCheck(false, state);
    }

    public void handleLanguageChanged(Locale locale) {
        this.doProblemsCheck(false, null);
    }

    private void problemMissingReusedProject(IReusedProjectPO node, String label) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerProjectDoesNotExist, (Object[])new String[]{label}), 2, "", node, ProblemType.REASON_PROJECT_DOES_NOT_EXIST);
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof ICategoryPO) {
            return;
        }
        if (po instanceof IAUTMainPO) {
            this.doProblemsCheck(false, null);
            return;
        }
        if (dataState == DataEventDispatcher.DataState.Deleted && po instanceof ISpecTestCasePO) {
            this.doProblemsCheck(true, null);
            return;
        }
        if (dataState == DataEventDispatcher.DataState.Added && updateState == DataEventDispatcher.UpdateState.all && po instanceof ISpecTestCasePO) {
            return;
        }
        if (dataState == DataEventDispatcher.DataState.Renamed) {
            if (po instanceof ISpecTestCasePO) {
                return;
            }
            this.doProblemsCheck(false, null);
            return;
        }
        if (updateState != DataEventDispatcher.UpdateState.onlyInEditor) {
            this.doProblemsCheck(true, null);
        }
    }

    private void doProblemsCheck(boolean checkCompNamesPair, DataEventDispatcher.ServerState state) {
        this.initProblems();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            this.problemNoProjectExists();
        } else {
            if (project.getTestSuiteCont().getTestSuiteList().size() == 0) {
                this.problemNoTestSuiteExists();
            }
            this.checkAllTestSuites();
            this.checkAllAutConfigs();
            if (project.getIsProtected()) {
                this.problemProtectedProjectLoaded();
            }
        }
        if (checkCompNamesPair) {
            this.checkCompNamesPairs();
        } else {
            this.copyCompNamesProblems();
        }
        if (checkCompNamesPair) {
            this.checkMissingProjects();
        } else {
            this.copyMissingProjectProblems();
        }
        this.checkReusedProjectLanguages();
        this.checkServerState(state);
        this.cleanupProblems();
    }

    private void copyCompNamesProblems() {
        for (IMarker marker : this.m_markerList) {
            if (!this.isCompNameRelated(marker) || this.m_markerToShowList.contains(marker)) continue;
            this.m_markerToShowList.add(marker);
        }
    }

    private void copyMissingProjectProblems() {
        for (IMarker marker : this.m_markerList) {
            if (!this.isMissingProjectRelated(marker) || this.m_markerToShowList.contains(marker)) continue;
            this.m_markerToShowList.add(marker);
        }
    }

    private boolean isCompNameRelated(IMarker marker) {
        try {
            return marker.getType().equals("org.eclipse.jubula.client.ui.gdProblem") && this.m_compNameProblemTypes.contains(marker.getAttribute("gdReason"));
        }
        catch (CoreException ce) {
            log.error((Object)(String.valueOf(Messages.CouldNotRetrieveTypeForMarker) + ":" + " " + marker + "." + " " + Messages.TheMarkerWillNotBeShown + "."), (Throwable)ce);
            return false;
        }
    }

    private boolean isMissingProjectRelated(IMarker marker) {
        try {
            return marker.getType().equals("org.eclipse.jubula.client.ui.gdProblem") && this.m_missingProjectProblemTypes.contains(marker.getAttribute("gdReason"));
        }
        catch (CoreException ce) {
            log.error((Object)(String.valueOf(Messages.CouldNotRetrieveTypeForMarker) + ":" + " " + marker + "." + " " + Messages.TheMarkerWillNotBeShown + "."), (Throwable)ce);
            return false;
        }
    }

    private void checkAllTestSuites() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project.getAutMainList().size() == 0) {
            this.problemNoAutForProjectExists();
        } else {
            this.checkAutConfigs();
        }
        List testSuites = project.getTestSuiteCont().getTestSuiteList();
        for (ITestSuitePO testSuite : testSuites) {
            if (testSuite.getAut() == null) {
                this.problemNoAutForTestSuiteSelected(testSuite);
            }
            if (testSuite.getNodeListSize() == 0) {
                this.problemNoEmptyTestSuiteAllowed(testSuite);
                continue;
            }
            if (testSuite.getAut() == null) continue;
            for (IProblem problem : testSuite.getProblems()) {
                if (!problem.isWithMarker()) continue;
                switch (problem.getProblemType()) {
                    case REASON_TD_INCOMPLETE: 
                    case REASON_OM_INCOMPLETE: 
                    case REASON_MISSING_SPEC_TC: {
                        if (!this.checkTS(testSuite)) {
                            return;
                        }
                    }
                    case EXTERNAL: {
                        this.createProblem(NLS.bind((String)problem.getMarkerMessage(), (Object[])new String[]{testSuite.getName()}), this.getMarkerSeverity(problem), String.valueOf(Messages.ProblemCheckerTestSuite) + testSuite.getName(), testSuite, problem.getProblemType());
                        break;
                    }
                }
            }
        }
    }

    private int getMarkerSeverity(IProblem problem) {
        int statusSeverity = problem.getSeverity();
        int markerSeverity = 0;
        if (statusSeverity == 2) {
            markerSeverity = 1;
        } else if (statusSeverity == 4 || statusSeverity == 8) {
            markerSeverity = 2;
        }
        return markerSeverity;
    }

    private void checkAutConfigs() {
        InetAddress connectedServer = null;
        try {
            if (!ServerConnection.getInstance().isConnected()) {
                return;
            }
            connectedServer = InetAddress.getByName(ServerConnection.getInstance().getCommunicator().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (ConnectionException connectionException) {
            return;
        }
        for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            boolean isMatchingServer = false;
            InetAddress configServer = null;
            for (IAUTConfigPO config : aut.getAutConfigSet()) {
                try {
                    configServer = InetAddress.getByName(config.getServer());
                    if (!configServer.equals(connectedServer) && (configServer == null || !"127.0.0.1".equals(configServer.getHostAddress()) || !connectedServer.getCanonicalHostName().equals(InetAddress.getLocalHost().getCanonicalHostName()))) continue;
                    isMatchingServer = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {}
            }
            if (isMatchingServer) continue;
            this.problemNoAutConfigForServerExists(aut);
        }
    }

    private void checkAllAutConfigs() {
        Set autList = GeneralStorage.getInstance().getProject().getAutMainList();
        for (IAUTMainPO mainPO : autList) {
            for (IAUTConfigPO config : mainPO.getAutConfigSet()) {
                String jarFile = config.getValue("JAR_FILE", null);
                String classPath = config.getValue("CLASSPATH", null);
                if ("".equals(jarFile)) {
                    if ("".equals(classPath)) {
                        this.problemNoJarOrClassPathForAutConfigExists(config, mainPO);
                    }
                } else if ("".equals(classPath) && "".equals(jarFile)) {
                    this.problemNoJarOrClassPathForAutConfigExists(config, mainPO);
                }
                if (!"".equals(config.getServer())) continue;
                this.problemNoServerForAutConfigExists(config, mainPO);
            }
        }
    }

    private void checkServerState(DataEventDispatcher.ServerState state) {
        boolean isServerDefined;
        String serverPortPref = Plugin.getDefault().getPreferenceStore().getString("SERVER_SETTINGS_KEY");
        boolean isConnected = false;
        boolean bl = isServerDefined = serverPortPref.length() != 0;
        if (state == null) {
            try {
                isConnected = ServerConnection.getInstance().isConnected();
            }
            catch (ConnectionException connectionException) {}
        } else {
            switch (state) {
                case Connected: {
                    isConnected = true;
                    break;
                }
                case Disconnected: {
                    isConnected = false;
                    break;
                }
            }
        }
        if (!isServerDefined) {
            this.problemNoServerDefined();
        } else if (!isConnected) {
            this.problemNoAutStarterConnection();
        }
    }

    private void createProblem(String message, int messageType, String location, Object object, ProblemType type) {
        boolean existProblem = false;
        for (IMarker marker : this.m_markerList) {
            try {
                if (!marker.getAttribute("location").equals(location) || !marker.getAttribute("severity").equals(messageType) || !marker.getAttribute("message").equals(message) || (object == null || !object.toString().equals(marker.getAttribute("gdObject"))) && (object != null || marker.getAttribute("gdObject") != null)) continue;
                existProblem = true;
                this.m_markerToShowList.add(marker);
            }
            catch (CoreException coreException) {}
        }
        if (existProblem) {
            return;
        }
        try {
            IMarker marker;
            marker = this.m_resource.createMarker("org.eclipse.jubula.client.ui.gdProblem");
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("severity", messageType);
            marker.setAttribute("message", (Object)message);
            if (object != null) {
                marker.setAttribute("gdObject", (Object)object.toString());
            } else {
                marker.setAttribute("gdObject", null);
            }
            marker.setAttribute("gdReason", type.ordinal());
            if (object instanceof INodePO) {
                INodePO node = (INodePO)object;
                marker.setAttribute("tstNodeName", (Object)node.getName());
            } else {
                marker.setAttribute("tstNodeName", (Object)"");
            }
            this.m_markerList.add(marker);
            this.m_markerToShowList.add(marker);
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
    }

    private IMarker[] findProblems() {
        String type = "org.eclipse.jubula.client.ui.gdProblem";
        IMarker[] markers = null;
        try {
            markers = this.m_resource.findMarkers(type, true, 2);
        }
        catch (CoreException coreException) {}
        return markers;
    }

    private void refreshProblems() {
        DataEventDispatcher.getInstance().fireProblemChangedListener();
    }

    private void cleanupProblems() {
        boolean doLoop = true;
        block4: while (doLoop) {
            doLoop = false;
            for (IMarker marker : this.m_markerList) {
                if (this.m_markerToShowList.contains(marker)) continue;
                try {
                    this.m_markerList.remove(marker);
                    marker.delete();
                }
                catch (CoreException coreException) {}
                doLoop = true;
                continue block4;
            }
        }
        IMarker[] iMarkerArray = this.findProblems();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker;
            marker = iMarkerArray[n2];
            if (!this.m_markerList.contains(marker) || !this.m_markerToShowList.contains(marker)) {
                try {
                    this.m_markerList.remove(marker);
                    this.m_markerToShowList.remove(marker);
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        this.refreshProblems();
    }

    private void initProblems() {
        this.m_markerToShowList.clear();
    }

    private void problemNoAutStarterConnection() {
        this.createProblem(Messages.ProblemCheckerConnectToGDServer, 0, "", Messages.Connection, ProblemType.REASON_CONNECTED_TO_NO_SERVER);
    }

    private void problemProtectedProjectLoaded() {
        this.createProblem(Messages.ProblemCheckerProtectedProject, 0, "", Messages.ProtectedProject, ProblemType.REASON_PROTECTED_PROJECT);
    }

    private void problemNoServerDefined() {
        this.createProblem(Messages.ProblemCheckerNoServer, 1, "", Messages.NoServer, ProblemType.REASON_NO_SERVER_DEFINED);
    }

    private void problemNoProjectExists() {
        this.createProblem(Messages.GDStateControllerInfoNoProject, 0, "", Messages.Project, ProblemType.REASON_NO_PROJECT);
    }

    private void problemNoTestSuiteExists() {
        this.createProblem(Messages.ProblemCheckerNoTestSuite, 0, "", Messages.Suite, ProblemType.REASON_NO_TESTSUITE);
    }

    private void problemNoAutForProjectExists() {
        this.createProblem(Messages.ProblemCheckerNoAutExists, 1, "", Messages.Project, ProblemType.REASON_NO_AUT_FOR_PROJECT_EXISTS);
    }

    private void problemNoAutForTestSuiteSelected(ITestSuitePO testSuite) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerNoAutSelected, (Object[])new String[]{testSuite.getName()}), 2, String.valueOf(Messages.ProblemCheckerTestSuite) + testSuite.getName(), testSuite, ProblemType.REASON_NO_AUT_FOR_TESTSUITE_SELECTED);
    }

    private void problemNoJarOrClassPathForAutConfigExists(IAUTConfigPO config, IAUTMainPO aut) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerAutConfigMissesJar, (Object[])new String[]{config.getName(), aut.getName()}), 1, String.valueOf(Messages.ProblemCheckerAUT) + aut.getName(), aut, ProblemType.REASON_NOJAR_FOR_AUTCONFIG);
    }

    private void problemNoServerForAutConfigExists(IAUTConfigPO config, IAUTMainPO aut) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerAutConfigMissesJar, (Object[])new String[]{config.getName(), aut.getName()}), 1, String.valueOf(Messages.ProblemCheckerAUT) + aut.getName(), aut, ProblemType.REASON_NOSERVER_FOR_AUTCONFIG);
    }

    private void problemNoAutConfigForServerExists(IAUTMainPO aut) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerAutNoConfigurationForServer, (Object[])new String[]{aut.getName()}), 1, String.valueOf(Messages.ProblemCheckerAUT) + aut.getName(), aut, ProblemType.REASON_NO_AUTCONFIG_FOR_SERVER_EXIST);
    }

    private void problemNoEmptyTestSuiteAllowed(ITestSuitePO testSuite) {
        if (!this.checkTS(testSuite)) {
            return;
        }
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerEmptyTestSuite, (Object[])new String[]{testSuite.getName()}), 1, String.valueOf(Messages.ProblemCheckerTestSuite) + testSuite.getName(), testSuite, ProblemType.REASON_EMPTY_TESTSUITE);
    }

    private void checkCompNamesPairs() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        CheckProblemsOperation op = new CheckProblemsOperation();
        SpecTreeTraverser traverser = new SpecTreeTraverser((INodePO)project, (ITreeNodeOperation)op);
        traverser.addOperation((ITreeNodeOperation)new ActionCheckOperation());
        traverser.traverse();
        traverser = new ExecTreeTraverser((INodePO)project, (ITreeNodeOperation)op);
        traverser.traverse();
    }

    private void checkMissingProjects() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        for (IReusedProjectPO reused : project.getUsedProjects()) {
            boolean reusedProjectExists = false;
            try {
                reusedProjectExists = ProjectPM.loadProject((IReusedProjectPO)reused) != null;
            }
            catch (JBException jBException) {}
            if (reusedProjectExists) continue;
            this.problemMissingReusedProject(null, reused.getName());
        }
    }

    private void checkReusedProjectLanguages() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        List langList = project.getLangHelper().getLanguageList();
        for (IReusedProjectPO reused : project.getUsedProjects()) {
            IProjectPO reusedProject = null;
            try {
                reusedProject = ProjectPM.loadProject((IReusedProjectPO)reused);
                if (reusedProject == null) continue;
                List reusedLangList = reusedProject.getLangHelper().getLanguageList();
                for (Locale lang : langList) {
                    if (reusedLangList.contains(lang)) continue;
                    if (WorkingLanguageBP.getInstance().getWorkingLanguage().equals(lang)) {
                        this.problemReusedProjectMissingLang(lang, reused.getName(), 2);
                        continue;
                    }
                    this.problemReusedProjectMissingLang(lang, reused.getName(), 1);
                }
            }
            catch (JBException jBException) {}
        }
    }

    private void problemReusedProjectMissingLang(Locale lang, String name, int severity) {
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerReusedProjectMissingLanguage, (Object[])new String[]{name, lang.getDisplayName()}), severity, "", null, ProblemType.REASON_REUSED_PROJECT_MISSING_LANG);
    }

    private void problemDeprecatedActionFound(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerDeprecatedAction, (Object[])new String[]{cap.getName(), tcPO.getName()}), 1, String.valueOf(Messages.ProblemCheckerTestCase) + tcPO.getName(), cap, ProblemType.REASON_DEPRECATED_ACTION);
    }

    private void problemDeprecatedCompFound(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerDeprecatedComp, (Object[])new String[]{cap.getName(), tcPO.getName()}), 1, String.valueOf(Messages.ProblemCheckerTestCase) + tcPO.getName(), cap, ProblemType.REASON_DEPRECATED_COMP);
    }

    private void problemCompDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), CompSystemI18n.getString((String)cap.getComponentType(), (boolean)true)}), 2, String.valueOf(Messages.ProblemCheckerTestCase) + tcPO.getName(), cap, ProblemType.REASON_COMP_DOES_NOT_EXIST);
    }

    private void problemActionDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), cap.getComponentName()}), 2, String.valueOf(Messages.ProblemCheckerTestCase) + tcPO.getName(), cap, ProblemType.REASON_COMP_DOES_NOT_EXIST);
    }

    private void problemParamDoesNotExist(ICapPO cap) {
        ITestCasePO tcPO = (ITestCasePO)cap.getParentNode();
        this.createProblem(NLS.bind((String)Messages.ProblemCheckerCompDoesNotExist, (Object[])new String[]{cap.getName(), tcPO.getName(), cap.getComponentName()}), 2, String.valueOf(Messages.ProblemCheckerTestCase) + tcPO.getName(), cap, ProblemType.REASON_COMP_DOES_NOT_EXIST);
    }

    private boolean checkTS(ITestSuitePO testSuite) {
        Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
        return testSuite.getAut() != null && WorkingLanguageBP.getInstance().isTestSuiteLanguage(workLang, testSuite);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ActionCheckOperation
    implements ITreeNodeOperation<INodePO> {
        private ActionCheckOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (node instanceof ICapPO) {
                ICapPO capPO = (ICapPO)node;
                if (capPO.getMetaAction().isDeprecated()) {
                    ProblemsBP.this.problemDeprecatedActionFound(capPO);
                }
                if (capPO.getMetaComponentType().isDeprecated()) {
                    ProblemsBP.this.problemDeprecatedCompFound(capPO);
                }
            }
            return true;
        }

        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CheckProblemsOperation
    implements ITreeNodeOperation<INodePO> {
        private CheckProblemsOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            block7: {
                block6: {
                    if (!(node instanceof IExecTestCasePO)) break block6;
                    IExecTestCasePO execTC = (IExecTestCasePO)node;
                    if (!execTC.getCompleteSpecTcFlag()) break block7;
                    for (ICompNamesPairPO pair : execTC.getCompNamesPairs()) {
                        String type = Utils.getComponentType(execTC, pair.getFirstName());
                        pair.setType(type);
                        if (type != null && !"".equals(type)) continue;
                        this.problemNoCompTypeForCompNamesPairExists(execTC);
                    }
                    break block7;
                }
                if (node instanceof ICapPO) {
                    String message;
                    ICapPO cap = (ICapPO)node;
                    if (cap.getMetaComponentType() instanceof InvalidComponent) {
                        message = String.valueOf(Messages.Component) + ":" + " " + cap.getComponentType();
                        log.error((Object)(String.valueOf(Messages.CouldNotFind) + " " + message));
                        ProblemsBP.this.problemCompDoesNotExist(cap);
                    } else if (cap.getMetaAction() instanceof InvalidAction) {
                        message = String.valueOf(Messages.CouldNotFindAction) + " " + CompSystemI18n.getString((String)cap.getActionName(), (boolean)true) + "\n" + "in" + " " + Messages.Component + ":" + " " + cap.getComponentType();
                        log.error((Object)message);
                        ProblemsBP.this.problemActionDoesNotExist(cap);
                    }
                    for (Object paramObj : cap.getParameterList()) {
                        if (!(paramObj instanceof InvalidParam)) continue;
                        Param param = (Param)paramObj;
                        String message2 = String.valueOf(Messages.Component) + ":" + " " + cap.getComponentType() + "\n" + Messages.Action + ":" + " " + CompSystemI18n.getString((String)cap.getActionName(), (boolean)true) + "\n" + Messages.Parameter + ":" + " " + CompSystemI18n.getString((String)param.getName(), (boolean)true);
                        log.error((Object)(String.valueOf(Messages.CouldNotFind) + " " + message2));
                        ProblemsBP.this.problemParamDoesNotExist(cap);
                    }
                }
            }
            return true;
        }

        private void problemNoCompTypeForCompNamesPairExists(IExecTestCasePO execTC) {
            if (execTC.getParentNode() == null) {
                return;
            }
            String name = execTC.getParentNode().getName();
            if ("".equals(name) && execTC.getParentNode() instanceof IExecTestCasePO) {
                name = ((IExecTestCasePO)execTC.getParentNode()).getSpecTestCase().getName();
            }
            String location = Messages.ProblemCheckerTestCase;
            if (execTC.getParentNode() instanceof ITestSuitePO) {
                location = Messages.ProblemCheckerTestSuite;
            }
            ProblemsBP.this.createProblem(NLS.bind((String)Messages.ProblemCheckerNoCompType, (Object[])new String[]{name}), 1, String.valueOf(location) + name, execTC.getParentNode(), ProblemType.REASON_NO_COMPTYPE);
        }

        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }
    }
}

