/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolkitBP
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    private static ToolkitBP instance = null;

    private ToolkitBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
    }

    public void handleProjectLoaded() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            UsedToolkitBP.getInstance().getToolkitLevel((INodePO)project);
        }
    }

    public static ToolkitBP getInstance() {
        if (instance == null) {
            instance = new ToolkitBP();
        }
        return instance;
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof INodePO && DataEventDispatcher.DataState.StructureModified == dataState) {
            INodePO node = (INodePO)po;
            if (po instanceof ISpecTestCasePO) {
                UsedToolkitBP.getInstance().updateToolkitLevel(node, node.getToolkitLevel());
            }
        }
    }

    public boolean checkXMLVersion(Set<IUsedToolkitPO> usedToolkits) {
        Dialog dialog;
        List errors = UsedToolkitBP.getInstance().checkUsedToolkitPluginVersions(usedToolkits);
        if (errors.isEmpty()) {
            return true;
        }
        boolean loadProject = true;
        Integer messageID = null;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict1);
        for (UsedToolkitBP.ToolkitPluginError error : errors) {
            String toolkitId = error.getToolkitId();
            ToolkitPluginDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(toolkitId);
            String toolkitName = desc != null ? desc.getName() : toolkitId;
            strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict2).append(toolkitName).append(Messages.OpenProjectActionToolkitVersionConflict3);
            UsedToolkitBP.ToolkitPluginError.ERROR errorType = error.getError();
            String descr = Messages.OpenProjectActionToolkitVersionConflict5;
            switch (errorType) {
                case MAJOR_VERSION_ERROR: {
                    messageID = MessageIDs.E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR;
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4a);
                    strBuilder.append(descr);
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_HIGHER: {
                    messageID = MessageIDs.E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR;
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4b);
                    strBuilder.append(descr);
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_LOWER: {
                    if (loadProject) {
                        messageID = MessageIDs.Q_LOAD_PROJECT_TOOLKIT_MINOR_VERSION_LOWER;
                    }
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4c);
                    break;
                }
                default: {
                    Assert.notReached((String)(String.valueOf(Messages.UnknownErrorType) + ":" + " " + String.valueOf(errorType)));
                }
            }
        }
        String[] details = null;
        if (!messageID.equals(MessageIDs.Q_LOAD_PROJECT_TOOLKIT_MINOR_VERSION_LOWER)) {
            details = new String[]{strBuilder.toString()};
        }
        if ((dialog = Utils.createMessageDialog(messageID, null, details)).getReturnCode() == 1) {
            loadProject = false;
        }
        return loadProject;
    }
}

