/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers;

import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;

public abstract class AbstractComponentNameViewerUpdater
implements DataEventDispatcher.IDataChangedListener {
    private IComponentNameCache m_compNameCache;

    public AbstractComponentNameViewerUpdater(IComponentNameCache compNameCache) {
        this.m_compNameCache = compNameCache;
    }

    public final void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof IComponentNamePO) {
            IComponentNamePO compName = (IComponentNamePO)po;
            switch (dataState) {
                case Deleted: {
                    this.remove(compName);
                    break;
                }
                case Renamed: {
                    this.update(compName, null);
                    break;
                }
                case Added: {
                    this.refresh();
                    break;
                }
            }
        } else if (po instanceof IObjectMappingCategoryPO) {
            switch (dataState) {
                case StructureModified: {
                    this.refresh();
                }
            }
        }
    }

    protected abstract void refresh();

    protected abstract void update(IComponentNamePO var1, String[] var2);

    protected abstract void remove(IComponentNamePO var1);
}

