/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.dialogs.nag.RCPAUTStartDelayNagTask;
import org.eclipse.jubula.client.ui.handlers.AbstractStartTestHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.JBThread;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.client.ui.utils.ServerManager;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.communication.message.StopAUTServerMessage;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class TestExecutionGUIController {
    static final Log LOG = LogFactory.getLog(TestExecutionGUIController.class);
    private static final int NAGGER_TIMEOUT = 120000;

    private TestExecutionGUIController() {
    }

    public static void startAUT(final IAUTMainPO aut, final IAUTConfigPO conf) {
        new JBThread(){
            private TimerTask m_infoRCPTask = null;

            public void run() {
                try {
                    if (aut.getToolkit().equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                        AutIdentifier autId = new AutIdentifier((String)conf.getConfigMap().get("AUT_ID"));
                        this.m_infoRCPTask = new RCPAUTStartDelayNagTask(autId);
                        Timer timer = new Timer();
                        try {
                            timer.schedule(this.m_infoRCPTask, 120000L);
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    TestExecutionContributor.getInstance().startAUTaction(aut, conf);
                }
                catch (ToolkitPluginException toolkitPluginException) {
                    this.interrupt();
                    Utils.createMessageDialog(MessageIDs.E_AUT_TOOLKIT_NOT_AVAILABLE);
                }
            }

            public void interrupt() {
                TestExecutionGUIController.disconnectFromServer();
                if (this.m_infoRCPTask != null) {
                    this.m_infoRCPTask.cancel();
                }
                super.interrupt();
            }

            protected void errorOccured() {
                if (this.m_infoRCPTask != null) {
                    this.m_infoRCPTask.cancel();
                }
            }
        }.start();
    }

    public static void stopAUT(AutIdentifier autId) {
        TestExecutionContributor.getInstance().stopAUTaction(autId);
    }

    public static void startTestSuite(final ITestSuitePO ts, final AutIdentifier autId, final boolean autoScreenshot) {
        TestExecutionContributor.setClientMinimized(true);
        JBThread t = new JBThread("Initialize Test Execution"){

            public void run() {
                if (!AbstractStartTestHandler.prepareTestExecution()) {
                    TestExecutionGUIController.stopTestSuite();
                }
                TestExecutionContributor.getInstance().startTestSuiteAction(ts, autId, autoScreenshot);
            }

            protected void errorOccured() {
            }
        };
        t.start();
        ts.setStarted(true);
    }

    public static void stopTestSuite() {
        JBThread t = new JBThread(){

            public void run() {
                TestExecutionContributor.getInstance().stopTestSuiteAction();
                List testSuites = GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList();
                for (ITestSuitePO ts : testSuites) {
                    ts.setStarted(false);
                }
            }

            protected void errorOccured() {
            }
        };
        t.start();
    }

    public static void connectToServer(final ServerManager.Server server) {
        final String jobName = NLS.bind((String)Messages.UIJobConnectToAUTAgent, (Object[])new Object[]{server.getName(), String.valueOf(server.getPort())});
        Job connectToAUTAgent = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                TestExecutionGUIController.connectToServerImpl(server);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob(connectToAUTAgent, null);
    }

    public static void disconnectFromServer() {
        JBThread t = new JBThread(){

            public void run() {
                try {
                    if (AUTConnection.getInstance().isConnected()) {
                        ServerConnection.getInstance().request((Message)new StopAUTServerMessage(), new ICommand(){

                            public Message execute() {
                                return null;
                            }

                            public Message getMessage() {
                                return null;
                            }

                            public void setMessage(Message message) {
                            }

                            public void timeout() {
                            }
                        }, 2000);
                    }
                }
                catch (BaseConnection.NotConnectedException notConnectedException) {
                }
                catch (ConnectionException connectionException) {
                }
                catch (CommunicationException communicationException) {}
                TestExecutionContributor.getInstance().disconnectFromServeraction();
            }

            protected void errorOccured() {
            }
        };
        t.start();
    }

    private static void connectToServerImpl(ServerManager.Server server) {
        TestExecutionContributor.getInstance().connectToServeraction(server.getName(), server.getPort().toString());
        try {
            if (ServerConnection.getInstance().isConnected()) {
                ServerConnection.getInstance();
                ServerConnection connection = ServerConnection.getInstance();
                SendCompSystemI18nMessage message = new SendCompSystemI18nMessage();
                message.setResourceBundles(CompSystemI18n.bundlesToString());
                try {
                    connection.send((Message)message);
                }
                catch (BaseConnection.NotConnectedException e) {
                    LOG.error((Object)"Could not send CompSystemI18nResourceBundle to Server", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)"Could not send CompSystemI18nResourceBundle to Server", (Throwable)e);
                }
                catch (CommunicationException e) {
                    LOG.error((Object)"Could not send CompSystemI18nResourceBundle to Server", (Throwable)e);
                }
            }
        }
        catch (ConnectionException connectionException) {
            DataEventDispatcher.getInstance().fireServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
        }
        if (Plugin.getActiveView() != null) {
            Plugin.showStatusLine((IWorkbenchPart)Plugin.getActiveView());
        }
    }
}

