/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.databinding.validators;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.ui.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataManagerNameValidator
implements IValidator {
    private Set<String> m_alreadyUsedNames;

    public TestDataManagerNameValidator(String oldName, Set<String> usedNames) {
        this.m_alreadyUsedNames = usedNames;
    }

    public IStatus validate(Object value) {
        return this.isTestDataCubeName(String.valueOf(value));
    }

    public IStatus isTestDataCubeName(String stringValue) {
        IStatus is = TestDataManagerNameValidator.isValidTestDataCubeString(stringValue);
        if (!is.isOK()) {
            return is;
        }
        if (!this.m_alreadyUsedNames.contains(stringValue)) {
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)Messages.TestDataCubeErrorExists);
    }

    public static IStatus isValidTestDataCubeString(String stringValue) {
        if (StringUtils.isEmpty((String)stringValue)) {
            return ValidationStatus.error((String)Messages.TestDataCubeErrorEmpty);
        }
        if (stringValue.startsWith(" ") || stringValue.charAt(stringValue.length() - 1) == ' ') {
            return ValidationStatus.error((String)Messages.TestDataCubeErrorNoSpaceAtStartOrEnd);
        }
        char[] cArray = stringValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isISOControl(ch)) {
                return ValidationStatus.error((String)Messages.TestDataCubeErrorInvalidChar);
            }
            ++n2;
        }
        return ValidationStatus.ok();
    }
}

