/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DBLoginDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_3 = 3;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 2;
    private String m_message = Messages.DBLoginDialogMessage;
    private JBText m_userText;
    private Label m_userLabel;
    private JBText m_pwdText;
    private Label m_pwdLabel;
    private ComboViewer m_connectionComboViewer;
    private String m_user;
    private String m_pwd;
    private DatabaseConnection m_dbConn;
    private List<DatabaseConnection> m_availableConnections;
    private boolean m_isEmbeddedOrNoSelection = false;

    public DBLoginDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
        this.setMessage(this.m_message);
        this.setTitle(Messages.DBLoginDialogTitle);
        this.setTitleImage(IconConstants.DB_LOGIN_DIALOG_IMAGE);
        this.getShell().setText(Messages.DBLoginDialogShell);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayoutParent);
        Plugin.createSeparator(parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        area.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createSchemaCombobox(area);
        this.createUserTextField(area);
        this.createPasswordTextField(area);
        this.fillConnectionCombobox();
        this.setUserAndPwdVisible(!this.m_isEmbeddedOrNoSelection);
        Plugin.createSeparator(parent);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.dbLoginContextId");
        this.setHelpAvailable(true);
        return area;
    }

    public int open() {
        this.setMessage(this.m_message);
        return super.open();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.m_userText.getText().length() == 0 || this.m_connectionComboViewer.getSelection().isEmpty() || this.m_availableConnections.isEmpty()) {
            this.getButton(0).setEnabled(false);
        }
        return button;
    }

    private void createUserTextField(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.m_userLabel = new Label(area, 0);
        this.m_userLabel.setText(Messages.DBLoginDialogUserLabel);
        this.m_userLabel.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.userLabel");
        this.m_userText = new JBText(area, 2048);
        this.m_userText.setData("TEST_COMP_NAME", "DBLoginDialog.userTxf");
        GridData gridData = this.newGridData();
        Layout.addToolTipAndMaxWidth(gridData, (Control)this.m_userText);
        this.m_userText.setLayoutData(gridData);
        Layout.setMaxChar(this.m_userText);
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        this.m_userText.setText(store.getString("USER_KEY"));
        this.m_userText.selectAll();
        this.m_userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DBLoginDialog.this.modifyUsernameFieldAction()) {
                    DBLoginDialog.this.modifyPasswordFieldAction();
                }
            }
        });
    }

    private void createPasswordTextField(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.m_pwdLabel = new Label(area, 0);
        this.m_pwdLabel.setText(Messages.DBLoginDialogPwdLabel);
        this.m_pwdLabel.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.pwdLabel");
        this.m_pwdText = new JBText(area, 0x400800);
        this.m_pwdText.setData("TEST_COMP_NAME", "DBLoginDialog.pwdTxf");
        GridData gridData = this.newGridData();
        Layout.addToolTipAndMaxWidth(gridData, (Control)this.m_pwdText);
        this.m_pwdText.setLayoutData(gridData);
        Layout.setMaxChar(this.m_pwdText);
        if (!StringUtils.isEmpty((String)this.m_userText.getText())) {
            this.m_pwdText.setFocus();
        }
        this.m_pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DBLoginDialog.this.modifyPasswordFieldAction()) {
                    DBLoginDialog.this.modifyUsernameFieldAction();
                }
            }
        });
    }

    private void createSchemaCombobox(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        new Label(area, 0).setText(Messages.DBLoginDialogConnectionLabel);
        Combo connectionCombo = new Combo(area, 12);
        GridData gridData = this.newGridData();
        connectionCombo.setLayoutData((Object)gridData);
        this.m_connectionComboViewer = new ComboViewer(connectionCombo);
        this.m_connectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_connectionComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DatabaseConnection) {
                    return ((DatabaseConnection)element).getName();
                }
                return super.getText(element);
            }
        });
    }

    private void fillConnectionCombobox() {
        this.m_connectionComboViewer.setInput(this.m_availableConnections);
        if (this.m_availableConnections.size() == 1) {
            this.m_connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_availableConnections.get(0)));
        } else {
            String previouslySelectedConn = Plugin.getDefault().getPreferenceStore().getString("SCHEMA_KEY");
            for (DatabaseConnection conn : this.m_availableConnections) {
                if (!conn.getName().equals(previouslySelectedConn)) continue;
                this.m_connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)conn));
                break;
            }
        }
        this.selectSchemaCbxAction();
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        this.selectSchemaCbxAction();
        this.checkEmbeddedDbOrNoSchemaSelected((DatabaseConnection)sel.getFirstElement());
        this.m_connectionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                DBLoginDialog.this.selectSchemaCbxAction();
                DBLoginDialog.this.checkEmbeddedDbOrNoSchemaSelected((DatabaseConnection)sel.getFirstElement());
                DBLoginDialog.this.setUserAndPwdVisible(!DBLoginDialog.this.m_isEmbeddedOrNoSelection);
            }
        });
    }

    private void checkEmbeddedDbOrNoSchemaSelected(DatabaseConnection connection) {
        if (connection == null) {
            this.m_isEmbeddedOrNoSelection = true;
            return;
        }
        DatabaseConnectionInfo connInfo = connection.getConnectionInfo();
        String username = connInfo.getProperty("javax.persistence.jdbc.user");
        String password = connInfo.getProperty("javax.persistence.jdbc.password");
        if (username != null && password != null) {
            this.m_isEmbeddedOrNoSelection = true;
            Hibernator.setUser((String)username);
            Hibernator.setPw((String)password);
            this.m_userText.setText(username);
            this.m_pwdText.setText(password);
            this.enableOKButton(true);
        } else {
            this.m_userText.setText(Plugin.getDefault().getPreferenceStore().getString("USER_KEY"));
            this.m_isEmbeddedOrNoSelection = false;
        }
    }

    private void setUserAndPwdVisible(boolean visible) {
        this.m_userText.setVisible(visible);
        this.m_userLabel.setVisible(visible);
        this.m_pwdText.setVisible(visible);
        this.m_pwdLabel.setVisible(visible);
    }

    boolean modifyUsernameFieldAction() {
        this.m_userText.clearSelection();
        boolean isCorrect = true;
        int serverNameLength = this.m_userText.getText().length();
        if (serverNameLength == 0 || this.m_userText.getText().startsWith(" ") || this.m_userText.getText().charAt(serverNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setErrorMessage(null);
        } else if (serverNameLength == 0) {
            this.setErrorMessage(Messages.DBLoginDialogEmptyUser);
        } else {
            this.setErrorMessage(Messages.DBLoginDialogWrongUser);
        }
        this.enableOKButton(isCorrect);
        return isCorrect;
    }

    boolean modifyPasswordFieldAction() {
        boolean isCorrect = true;
        if (this.m_pwdText.getText().startsWith(" ") || this.m_pwdText.getText().endsWith(" ")) {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setMessage(this.m_message);
        } else {
            this.setErrorMessage(Messages.DBLoginDialogWrongPwd);
        }
        this.enableOKButton(isCorrect);
        return isCorrect;
    }

    private void selectSchemaCbxAction() {
        boolean isCorrect = true;
        if (this.m_availableConnections.isEmpty()) {
            this.setErrorMessage(Messages.DBLoginDialogNoSchemaAvailable);
            isCorrect = false;
        } else if (this.m_connectionComboViewer.getSelection().isEmpty()) {
            this.setErrorMessage(Messages.DBLoginDialogNoSchemaSelected);
            isCorrect = false;
        } else {
            this.setErrorMessage(null);
        }
        this.enableOKButton(isCorrect);
    }

    void enableOKButton(boolean enabled) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        this.m_user = this.m_userText.getText();
        this.m_pwd = this.m_pwdText.getText();
        this.m_dbConn = (DatabaseConnection)sel.getFirstElement();
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        store.setValue("USER_KEY", this.m_user);
        store.setValue("SCHEMA_KEY", this.m_dbConn.getName());
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        return gridData;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPwd() {
        return this.m_pwd;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.m_dbConn;
    }
}

