/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.DependencyFinderOp;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.TestCaseDialogContentProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.sorter.NodeNameViewerSorter;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;

public class TestCaseTreeDialog
extends TitleAreaDialog {
    public static final int ADD = 9999;
    public static final int TESTCASE = 10;
    public static final int EVENTHANDLER = 20;
    public static final int OPEN_TESTCASE = 30;
    private static final int NUM_COLUMNS_1 = 1;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private static final int WIDTH_HINT = 300;
    private TreeViewer m_treeViewer;
    private List<ISelectionListener> m_selectionListenerList = new ArrayList<ISelectionListener>();
    private String m_title = Messages.TestCaseTableDialogTitle;
    private String m_message = Messages.TestCaseTableDialogMessage;
    private String m_shellTitle = Messages.TestCaseTableDialogShellTitle;
    private String m_addButtonText = Messages.TestCaseTableDialogAdd;
    private int m_typeToAdd = 10;
    private ISpecTestCasePO m_parentTestCase;
    private int m_treeStyle = 4;
    private Button m_addButton;
    private Image m_image = IconConstants.ADD_TC_DIALOG_IMAGE;
    private Set<INodePO> m_circDependList = new HashSet<INodePO>();

    public TestCaseTreeDialog(Shell shell, ISpecTestCasePO parentTestCase, int treeStyle, int typeToAdd) {
        super(shell);
        Assert.verify((typeToAdd == 10 || typeToAdd == 20 || typeToAdd == 30 ? 1 : 0) != 0, (String)"Parameter 'typeToAdd' must be 'TESTCASE', 'OPEN_TESTCASE' or 'EVENTHANDLER'!");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_parentTestCase = parentTestCase;
        this.m_treeStyle = treeStyle;
        this.m_typeToAdd = typeToAdd;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image, int typeToAdd) {
        this(shell, parentTestCase, treeStyle, typeToAdd);
        this.m_title = title;
        this.m_message = message;
        this.m_shellTitle = shellTitle;
        this.m_image = image;
    }

    public TestCaseTreeDialog(Shell shell, String title, String message, ISpecTestCasePO parentTestCase, String shellTitle, int treeStyle, Image image, int typeToAdd, String addButtonText) {
        this(shell, title, message, parentTestCase, shellTitle, treeStyle, image, typeToAdd);
        this.m_addButtonText = addButtonText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.m_title);
        this.setMessage(this.m_message);
        this.getShell().setText(this.m_shellTitle);
        this.setTitleImage(this.m_image);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 2;
        gridLayoutParent.marginHeight = 2;
        parent.setLayout((org.eclipse.swt.widgets.Layout)gridLayoutParent);
        Plugin.createSeparator(parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        area.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        area.setLayoutData((Object)gridData);
        JBFilteredTree ft = new JBFilteredTree(area, this.m_treeStyle, new JBPatternFilter(), true);
        this.m_treeViewer = ft.getViewer();
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.heightHint = 300;
        Layout.addToolTipAndMaxWidth(layoutData, this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setLayoutData((Object)layoutData);
        this.m_treeViewer.setUseHashlookup(true);
        this.getInitialInput();
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.m_treeViewer.setContentProvider((IContentProvider)new TestCaseDialogContentProvider());
        this.m_treeViewer.setInput((Object)GeneralStorage.getInstance().getProject());
        this.m_treeViewer.setSorter((ViewerSorter)new NodeNameViewerSorter());
        Plugin.createSeparator(parent);
        return area;
    }

    private void getInitialInput() {
        if (this.m_parentTestCase != null) {
            DependencyFinderOp op = new DependencyFinderOp((INodePO)this.m_parentTestCase);
            TreeTraverser traverser = new TreeTraverser((INodePO)GeneralStorage.getInstance().getProject(), (ITreeNodeOperation)op, true);
            traverser.traverse(true);
            this.m_circDependList = op.getDependentNodes();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_addButton = this.createButton(parent, 9999, this.m_addButtonText, true);
        this.m_addButton.setEnabled(false);
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.notifyListener();
                TestCaseTreeDialog.this.setReturnCode(9999);
                TestCaseTreeDialog.this.close();
            }
        });
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection() != null) {
                    TestCaseTreeDialog.this.m_addButton.setEnabled(true);
                }
            }
        });
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObj = objectArray[n2];
                    if (TestCaseTreeDialog.this.m_circDependList.contains(selectedObj) || selectedObj instanceof ICategoryPO) {
                        TestCaseTreeDialog.this.m_addButton.setEnabled(false);
                    }
                    ++n2;
                }
            }
        });
        this.m_treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TestCaseTreeDialog.this.m_addButton.getEnabled()) {
                    return;
                }
                TestCaseTreeDialog.this.notifyListener();
                TestCaseTreeDialog.this.setReturnCode(9999);
                TestCaseTreeDialog.this.close();
            }
        });
        Button cancelButton = this.createButton(parent, 1, Messages.TestCaseTableDialogCancel, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeDialog.this.setReturnCode(1);
                TestCaseTreeDialog.this.close();
            }
        });
    }

    public void addSelectionListener(ISelectionListener listener) {
        if (!this.m_selectionListenerList.contains(listener)) {
            this.m_selectionListenerList.add(listener);
        }
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.m_selectionListenerList.remove(listener);
    }

    void notifyListener() {
        for (ISelectionListener listener : this.m_selectionListenerList) {
            listener.selectionChanged(null, this.m_treeViewer.getSelection());
        }
    }

    private class LabelProvider
    implements IColorProvider,
    ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ISpecTestCasePO) {
                if (TestCaseTreeDialog.this.m_circDependList.contains(element)) {
                    return IconConstants.TC_DISABLED_IMAGE;
                }
                return IconConstants.TC_IMAGE;
            }
            if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
                return IconConstants.CATEGORY_IMAGE;
            }
            return null;
        }

        public String getText(Object element) {
            return GeneralLabelProvider.getGDText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            if (element instanceof ISpecTestCasePO) {
                if (TestCaseTreeDialog.this.m_circDependList.contains(element)) {
                    return Layout.GRAY_COLOR;
                }
                return Layout.DEFAULT_OS_COLOR;
            }
            if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
                return Layout.GRAY_COLOR;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

