/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCubeContPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.SearchTreeAction;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.JubulaStateController;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.editors.PersistentObjectComparer;
import org.eclipse.jubula.client.ui.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.filter.JBBrowserPatternFilter;
import org.eclipse.jubula.client.ui.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.CentralTestDataContentProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.CentralTestDataLabelProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralTestDataEditor
extends AbstractJBEditor
implements DataEventDispatcher.IParamChangedListener {
    private Set<ITestDataCubePO> m_elementsToRefresh = new HashSet<ITestDataCubePO>();

    @Override
    protected void createPartControlImpl(Composite parent) {
        this.createMainPart(parent);
        GridData gridData = new GridData(1808);
        this.getMainTreeViewer().getControl().setLayoutData((Object)gridData);
        this.setControl(this.getMainTreeViewer().getControl());
        this.getMainTreeViewer().setContentProvider((IContentProvider)new CentralTestDataContentProvider());
        DecoratingLabelProvider lp = new DecoratingLabelProvider((ILabelProvider)new CentralTestDataLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        lp.setDecorationContext((IDecorationContext)new AbstractJBEditor.JBEditorDecorationContext(this));
        this.getMainTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        this.getMainTreeViewer().setSorter(new ViewerSorter());
        this.getMainTreeViewer().setComparer((IElementComparer)new PersistentObjectComparer());
        this.addTreeDoubleClickListener("org.eclipse.jubula.client.ui.commands.AddNewTestDataManager");
        this.addFocusListener(this.getMainTreeViewer());
        this.getEditorHelper().addListeners();
        this.setActionHandlers();
        this.setInitialInput();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addPropertyChangedListener((DataEventDispatcher.IPropertyChangedListener)this, true);
        ded.addParamChangedListener((DataEventDispatcher.IParamChangedListener)this, true);
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
    }

    @Override
    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeParamChangedListener((DataEventDispatcher.IParamChangedListener)this);
        this.getElementsToRefresh().clear();
        super.dispose();
    }

    @Override
    protected void createPartName() {
        this.setPartName(Messages.CentralTestDataEditorName);
    }

    private void addFocusListener(TreeViewer mainTreeViewer) {
        mainTreeViewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CentralTestDataEditor.this.getMainTreeViewer().setSelection(CentralTestDataEditor.this.getMainTreeViewer().getSelection(), true);
            }
        });
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.AddNewTestDataManager");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.rename");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.EditParameters");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.delete");
        mgr.add(SearchTreeAction.getAction());
        mgr.add((IContributionItem)new Separator());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("importWizardId", "org.eclipse.jubula.client.ui.importWizard.ImportTestDataSetsWizard");
        mgr.add(CommandHelper.createContributionItem("org.eclipse.ui.file.import", params, null, 8));
    }

    @Override
    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerCentralTestDataEditorContextId");
    }

    @Override
    protected void setInitialInput() {
        ITestDataCubeContPO rootPOTop = (ITestDataCubeContPO)this.getEditorHelper().getEditSupport().getWorkVersion();
        try {
            this.getTreeViewer().getTree().getParent().setRedraw(false);
            this.getTreeViewer().setInput((Object)rootPOTop);
            this.getTreeViewer().expandAll();
        }
        finally {
            this.getTreeViewer().getTree().getParent().setRedraw(true);
        }
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        try {
            try {
                editSupport.saveWorkVersion();
                this.updateReferencedParamNodes();
                this.getEditorHelper().resetEditableState();
                this.getEditorHelper().setDirty(false);
            }
            catch (IncompatibleTypeException pmce) {
                this.handlePMCompNameException(pmce);
                monitor.done();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                try {
                    this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException pMException) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
                monitor.done();
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateReferencedParamNodes() {
        HashSet nodesToRefresh = new HashSet();
        for (ITestDataCubePO tdc : this.getElementsToRefresh()) {
            nodesToRefresh.addAll(TestDataCubeBP.getReuser((IParameterInterfacePO)tdc));
        }
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        for (INodePO node : nodesToRefresh) {
            masterSession.refresh((Object)node);
        }
        this.getElementsToRefresh().clear();
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_CTD_EDITOR_IMAGE;
    }

    @Override
    public String getEditorPrefix() {
        return Messages.PluginCTD;
    }

    @Override
    public void handlePropertyChanged(boolean isCompNameChanged) {
        this.getMainTreeViewer().refresh();
    }

    public void handleParamChanged() {
        ISelection currentSelection = this.getMainTreeViewer().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObj = objectArray[n2];
                if (selectedObj instanceof ITestDataCubePO) {
                    this.getElementsToRefresh().add((ITestDataCubePO)selectedObj);
                }
                ++n2;
            }
        }
        this.getMainTreeViewer().refresh();
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof ITestDataCubePO) {
            if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                this.getEditorHelper().setDirty(true);
            }
            ITestDataCubePO tdc = (ITestDataCubePO)po;
            this.handleDataChanged(dataState, tdc, updateState);
        }
        this.getMainTreeViewer().refresh();
        this.getEditorHelper().handleDataChanged(po, dataState, updateState);
    }

    private void handleDataChanged(DataEventDispatcher.DataState dataState, ITestDataCubePO tdc, DataEventDispatcher.UpdateState updateState) {
        switch (dataState) {
            case Added: {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)tdc));
                break;
            }
            case Deleted: {
                break;
            }
            case Renamed: {
                this.getElementsToRefresh().add(tdc);
                break;
            }
            case ReuseChanged: {
                break;
            }
            case StructureModified: {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)tdc));
                break;
            }
        }
    }

    @Override
    protected void createMainPart(Composite parent) {
        JBFilteredTree ft = new JBFilteredTree(parent, 2818, new JBBrowserPatternFilter(), true);
        this.setMainTreeViewer(ft.getViewer());
        this.getMainTreeViewer().setUseHashlookup(true);
        JubulaStateController.getInstance().addSelectionListenerToSelectionService();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.firePropertyChange(258);
    }

    private Set<ITestDataCubePO> getElementsToRefresh() {
        return this.m_elementsToRefresh;
    }
}

