/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.model.LogicComponent;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.CutTreeItemActionOMEditor;
import org.eclipse.jubula.client.ui.actions.OMMarkInAutAction;
import org.eclipse.jubula.client.ui.actions.OMSetCategoryToMapInto;
import org.eclipse.jubula.client.ui.actions.PasteTreeItemActionOMEditor;
import org.eclipse.jubula.client.ui.actions.SearchTreeAction;
import org.eclipse.jubula.client.ui.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.businessprocess.OMEditorBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.ComponentNameTreeViewerUpdater;
import org.eclipse.jubula.client.ui.controllers.JubulaStateController;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.controllers.dnd.objectmapping.LimitingDragSourceListener;
import org.eclipse.jubula.client.ui.controllers.dnd.objectmapping.OMDropTargetListener;
import org.eclipse.jubula.client.ui.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.editingsupport.AbstractObjectMappingEditingSupport;
import org.eclipse.jubula.client.ui.editors.IJBEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.ObjectMappingConfigComponent;
import org.eclipse.jubula.client.ui.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.editors.PersistentObjectComparer;
import org.eclipse.jubula.client.ui.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.filter.ObjectMappingEditorPatternFilter;
import org.eclipse.jubula.client.ui.handlers.RevertEditorChangesHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.objectmapping.OMEditorTableContentProvider;
import org.eclipse.jubula.client.ui.provider.contentprovider.objectmapping.OMEditorTreeContentProvider;
import org.eclipse.jubula.client.ui.provider.contentprovider.objectmapping.ObjectMappingRow;
import org.eclipse.jubula.client.ui.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.jubula.client.ui.provider.selectionprovider.SelectionProviderIntermediate;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.SelectionChecker;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.views.ColumnSortListener;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.IMultiTreeViewerContainer;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.swt.IFocusService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMappingMultiPageEditor
extends MultiPageEditorPart
implements IJBPart,
IJBEditor,
IObjectMappingObserver,
GuiEventDispatcher.IEditorDirtyStateListener,
IMultiTreeViewerContainer,
IPropertyListener {
    private static final Log LOG = LogFactory.getLog(ObjectMappingMultiPageEditor.class);
    private static final String CAT_SEPARATOR = "/";
    private static final int SPLIT_PAGE_IDX = 0;
    private static final int TREE_PAGE_IDX = 1;
    private static final int TABLE_PAGE_IDX = 2;
    private JBEditorHelper m_editorHelper;
    private OMEditorBP m_omEditorBP;
    private TreeViewer m_compNameTreeViewer;
    private TreeViewer m_uiElementTreeViewer;
    private TreeViewer m_mappedComponentTreeViewer;
    private TreeViewer m_treeViewer;
    private TableViewer m_tableViewer;
    private ObjectMappingConfigComponent m_mappingConfigComponent;
    private IStructuredSelection m_treeSelection = StructuredSelection.EMPTY;
    private Set<LogicComponent> m_componentNames;
    private CutTreeItemActionOMEditor m_cutTreeItemAction;
    private PasteTreeItemActionOMEditor m_pasteTreeItemAction;
    private ComponentNameTreeViewerUpdater m_treeViewerUpdater;
    private RevertEditorChangesHandler m_revertEditorChangesAction = new RevertEditorChangesHandler();
    private Map<Integer, ISelectionProvider> m_pageToSelectionProvider = new HashMap<Integer, ISelectionProvider>();
    private EditorSelectionChangedListener m_editorSelectionChangedListener = new EditorSelectionChangedListener();
    private ActionListener m_actionListener = new ActionListener();
    private SelectionProviderIntermediate m_selectionProvider;
    private TreeViewer m_activeTreeViewer = null;
    private Text m_treeFilterText;
    private SelectionProviderIntermediate m_splitPaneSelectionProvider;

    protected void createPages() {
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_omEditorBP = new OMEditorBP(this);
        IObjectMappingPO objMap = this.getAut().getObjMap();
        if (objMap == null) {
            objMap = PoMaker.createObjectMappingPO();
            this.getAut().setObjMap(objMap);
        }
        this.checkMasterSessionUpToDate();
        this.createActions();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillTreeContextMenu(mgr);
            }
        });
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
        this.getEditorHelper().addListeners();
        this.getOmEditorBP().collectNewLogicalComponentNames();
        int splitPaneViewIndex = this.addPage(this.createSplitPanePageControl(this.getContainer(), menuMgr));
        int treeViewIndex = this.addPage(this.createTreePageControl(this.getContainer(), menuMgr));
        int tableViewIndex = this.addPage(this.createTablePageControl(this.getContainer()));
        int configViewIndex = this.addPage(this.createConfigPageControl(this.getContainer()));
        this.setPageText(splitPaneViewIndex, Messages.ObjectMappingEditorSplitPaneView);
        this.setPageText(treeViewIndex, Messages.ObjectMappingEditorTreeView);
        this.setPageText(tableViewIndex, Messages.ObjectMappingEditorTableView);
        this.setPageText(configViewIndex, Messages.ObjectMappingEditorConfigView);
        this.m_pageToSelectionProvider.put(splitPaneViewIndex, (ISelectionProvider)this.m_splitPaneSelectionProvider);
        this.m_pageToSelectionProvider.put(treeViewIndex, (ISelectionProvider)this.m_treeViewer);
        this.m_pageToSelectionProvider.put(tableViewIndex, (ISelectionProvider)this.m_tableViewer);
        this.m_pageToSelectionProvider.put(configViewIndex, new NullSelectionProvider());
        this.m_selectionProvider = new SelectionProviderIntermediate();
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
        this.m_selectionProvider.addSelectionChangedListener(this.m_actionListener);
        this.m_selectionProvider.addSelectionChangedListener(this.m_editorSelectionChangedListener);
        ObjectMappingEventDispatcher.addObserver((IObjectMappingObserver)this);
        this.m_treeViewerUpdater = new ComponentNameTreeViewerUpdater(this.m_treeViewer, (IComponentNameCache)this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache());
        this.checkAndFixInconsistentData();
        this.m_treeViewer.expandToLevel(2);
    }

    private void checkAndFixInconsistentData() {
        boolean isChanged = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        IWritableComponentNameCache compNameCache = this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache();
        isChanged |= this.fixCompNameReferences(objMap, (IComponentNameCache)compNameCache);
        if (isChanged |= this.removeDeletedCompNames(objMap, (IComponentNameCache)compNameCache)) {
            try {
                EditSupport editSupport = this.m_editorHelper.getEditSupport();
                editSupport.lockWorkVersion();
                this.m_editorHelper.setDirty(true);
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (PMAlreadyLockedException pMAlreadyLockedException) {
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
        }
    }

    private boolean removeDeletedCompNames(IObjectMappingPO objectMap, IComponentNameCache compNameCache) {
        boolean isChanged = false;
        HashSet<IObjectMappingAssoziationPO> assocsToDelete = new HashSet<IObjectMappingAssoziationPO>();
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            if (assoc.getTechnicalName() != null) continue;
            HashSet<String> compNamesToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                if (compNameCache.getCompNamePo(compNameGuid) != null) continue;
                compNamesToRemove.add(compNameGuid);
            }
            for (String toRemove : compNamesToRemove) {
                assoc.removeLogicalName(toRemove);
                isChanged = true;
            }
            if (!assoc.getLogicalNames().isEmpty()) continue;
            isChanged = true;
            assocsToDelete.add(assoc);
        }
        for (IObjectMappingAssoziationPO assoc : assocsToDelete) {
            assoc.getCategory().removeAssociation(assoc);
            this.getEditorHelper().getEditSupport().getSession().remove((Object)assoc);
        }
        return isChanged;
    }

    private void createActions() {
        this.m_cutTreeItemAction = new CutTreeItemActionOMEditor();
        this.m_pasteTreeItemAction = new PasteTreeItemActionOMEditor();
    }

    private Control createConfigPageControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        Composite configComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        configComposite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        configComposite.setLayout((Layout)layout);
        this.m_mappingConfigComponent = new ObjectMappingConfigComponent(configComposite, this.getAut().getObjMap(), this);
        this.createConfigContextMenu(configComposite);
        return configComposite;
    }

    private Control createTreePageControl(Composite parent, MenuManager contextMenuMgr) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        SashForm treeComp = new SashForm(parent, 2);
        GridLayout compLayout = new GridLayout(1, false);
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        treeComp.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        treeComp.setLayoutData((Object)gridData);
        JBFilteredTree ft = new JBFilteredTree((Composite)treeComp, 2818, new ObjectMappingEditorPatternFilter(), true);
        this.m_treeViewer = ft.getViewer();
        this.setTreeFilterText(ft.getFilterControl());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)this.m_treeViewer, this.getCompMapper());
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setSorter((ViewerSorter)new ObjectMappingTreeSorter());
        this.m_treeViewer.setComparer((IElementComparer)new PersistentObjectComparer());
        int ops = 2;
        Transfer[] transfers = new Transfer[]{org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionTransfer.getInstance()};
        this.m_treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)this.m_treeViewer, this.getAut()));
        this.m_treeViewer.addDropSupport(ops, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)this.m_treeViewer));
        this.m_omEditorBP = new OMEditorBP(this);
        this.m_treeViewer.setAutoExpandLevel(2);
        this.m_treeViewer.setInput((Object)this.getAut().getObjMap());
        this.createTreeContextMenu(this.m_treeViewer, contextMenuMgr);
        JubulaStateController.getInstance().addSelectionListenerToSelectionService();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        this.configureActionBars();
        FocusAdapter activeTreeListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = ObjectMappingMultiPageEditor.this.m_treeViewer;
            }
        };
        this.m_treeViewer.getTree().addFocusListener((FocusListener)activeTreeListener);
        ft.getFilterControl().addFocusListener((FocusListener)activeTreeListener);
        return treeComp;
    }

    private Control createSplitPanePageControl(Composite parent, MenuManager contextMenuMgr) {
        this.m_splitPaneSelectionProvider = new SelectionProviderIntermediate();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        SashForm mainSash = new SashForm(parent, 512);
        SashForm topSash = new SashForm((Composite)mainSash, 256);
        this.m_compNameTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedLogic", this.getAut().getObjMap().getUnmappedLogicalCategory(), contextMenuMgr);
        this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)this.m_compNameTreeViewer);
        this.m_uiElementTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedTech", this.getAut().getObjMap().getUnmappedTechnicalCategory(), contextMenuMgr);
        this.m_mappedComponentTreeViewer = this.createSplitPaneViewer((Composite)mainSash, "ObjectMappingEditor.Assigned", this.getAut().getObjMap().getMappedCategory(), contextMenuMgr);
        this.linkSelection(new TreeViewer[]{this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer});
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        return mainSash;
    }

    private void linkSelection(final TreeViewer[] treeViewersToLink) {
        TreeViewer[] treeViewerArray = treeViewersToLink;
        int n = treeViewersToLink.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeViewer viewer = treeViewerArray[n2];
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                        ObjectMappingMultiPageEditor.this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)viewer);
                        TreeViewer[] treeViewerArray = treeViewersToLink;
                        int n = treeViewersToLink.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeViewer viewerToDeselect = treeViewerArray[n2];
                            if (viewer != viewerToDeselect) {
                                viewerToDeselect.setSelection((ISelection)StructuredSelection.EMPTY);
                            }
                            ++n2;
                        }
                    }
                }
            });
            ++n2;
        }
    }

    private TreeViewer createSplitPaneViewer(Composite parent, String title, IObjectMappingCategoryPO topLevelCategory, MenuManager contextMenuMgr) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(I18n.getString((String)title));
        titleLabel.setLayoutData((Object)GridDataFactory.defaultsFor((Control)titleLabel).create());
        final TreeViewer viewer = new TreeViewer(composite);
        viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)viewer, this.getCompMapper());
        viewer.setUseHashlookup(true);
        viewer.setSorter((ViewerSorter)new ObjectMappingTreeSorter());
        viewer.setComparer((IElementComparer)new PersistentObjectComparer());
        viewer.setInput((Object)topLevelCategory);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)viewer, this.getAut()));
        viewer.addDropSupport(2, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)viewer));
        this.createTreeContextMenu(viewer, contextMenuMgr);
        DialogUtils.setWidgetName((Widget)viewer.getTree(), title);
        IFocusService focusService = (IFocusService)this.getSite().getService(IFocusService.class);
        focusService.addFocusTracker((Control)viewer.getTree(), title);
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = viewer;
            }
        });
        return viewer;
    }

    private void configureActionBars() {
        this.getTreeFilterText().addFocusListener(new FocusListener(){
            private IAction m_defaultCutAction;
            private IAction m_defaultPasteAction;
            {
                this.m_defaultCutAction = ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
                this.m_defaultPasteAction = ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
            }

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.m_defaultCutAction);
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.m_defaultPasteAction);
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)ObjectMappingMultiPageEditor.this.m_cutTreeItemAction);
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)ObjectMappingMultiPageEditor.this.m_pasteTreeItemAction);
                ObjectMappingMultiPageEditor.this.getEditorSite().getActionBars().updateActionBars();
            }
        });
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_cutTreeItemAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_pasteTreeItemAction);
        this.getEditorSite().getActionBars().updateActionBars();
    }

    public void setTreeFilterText(Text treeFilterText) {
        this.m_treeFilterText = treeFilterText;
    }

    public Text getTreeFilterText() {
        return this.m_treeFilterText;
    }

    private void createTreeContextMenu(TreeViewer viewer, MenuManager menuMgr) {
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    protected void fillTreeContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.CreateNewCategoryCommand");
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.m_cutTreeItemAction);
        mgr.add((IAction)this.m_pasteTreeItemAction);
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.delete");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.rename");
        mgr.add(SearchTreeAction.getAction());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.file.refresh");
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new Separator());
        mgr.add(OMSetCategoryToMapInto.getAction());
        mgr.add(OMMarkInAutAction.getAction());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowResponsibleNodes");
    }

    private void createConfigContextMenu(Composite configComposite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillConfigContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)configComposite);
        this.setConfigContextMenu((Control)configComposite, menu);
    }

    private void setConfigContextMenu(Control control, Menu menu) {
        control.setMenu(menu);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setConfigContextMenu(child, menu);
                ++n2;
            }
        }
    }

    protected void fillConfigContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
    }

    private void createTableContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillTableContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
    }

    protected void fillTableContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.file.refresh");
    }

    private Control createTablePageControl(Composite parent) {
        this.m_tableViewer = new TableViewer(parent, 68352);
        this.addLogicalNameColumn(this.m_tableViewer);
        this.addTechNameColumn(this.m_tableViewer);
        this.addCategoryColumn(this.m_tableViewer);
        this.addCompTypeColumn(this.m_tableViewer);
        TableViewerEditor.create((TableViewer)this.m_tableViewer, (ColumnViewerEditorActivationStrategy)new OMTableEditorActivationStrategy(this.m_tableViewer), (int)26);
        this.m_tableViewer.setContentProvider((IContentProvider)new OMEditorTableContentProvider());
        this.m_tableViewer.getTable().setLinesVisible(true);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        TableColumn sortColumn = this.m_tableViewer.getTable().getColumn(0);
        this.m_tableViewer.getTable().setSortColumn(sortColumn);
        this.m_tableViewer.getTable().setSortDirection(1024);
        ColumnSortListener sortListener = new ColumnSortListener(this.m_tableViewer, sortColumn);
        this.m_tableViewer.setComparator((ViewerComparator)sortListener);
        TableColumn[] tableColumnArray = this.m_tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.addSelectionListener((SelectionListener)sortListener);
            ++n2;
        }
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setInput((Object)this.getAut().getObjMap());
        this.createTableContextMenu();
        return this.m_tableViewer.getControl();
    }

    private TableViewerColumn addCompTypeColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(Messages.ObjectMappingEditorComponentType);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                IObjectMappingAssoziationPO assoc = row.getAssociation();
                String text = "";
                if (row.getLogicalNameIndex() != -1) {
                    String compNameGuid = (String)assoc.getLogicalNames().get(row.getLogicalNameIndex());
                    IComponentNamePO compName = ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getCompNamePo(compNameGuid);
                    text = compName != null ? CompSystemI18n.getString((String)compName.getComponentType()) : CompSystemI18n.getString((String)"CompNamesView.errorText");
                }
                return text;
            }
        });
        return column;
    }

    private TableViewerColumn addCategoryColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.CATEGORY_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorCategory);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                ArrayList<String> catPath = new ArrayList<String>();
                IObjectMappingCategoryPO category = row.getAssociation().getCategory();
                while (category != null) {
                    catPath.add(0, category.getName());
                    category = category.getParent();
                }
                StringBuilder sb = new StringBuilder();
                Iterator it = catPath.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                while (it.hasNext()) {
                    sb.append(ObjectMappingMultiPageEditor.CAT_SEPARATOR).append((String)it.next());
                }
                return sb.toString();
            }
        });
        return column;
    }

    private TableViewerColumn addLogicalNameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.LOGICAL_NAME_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorLogicalName);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                int logicalNameIndex = row.getLogicalNameIndex();
                if (logicalNameIndex < 0) {
                    return null;
                }
                return ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getName((String)row.getAssociation().getLogicalNames().get(logicalNameIndex));
            }
        });
        column.setEditingSupport((EditingSupport)new ObjectMappingCompNameEditingSupport((IComponentNameMapper)this.getCompMapper(), tableViewer));
        return column;
    }

    private TableViewerColumn addTechNameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.TECHNICAL_NAME_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorTechnicalName);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IObjectMappingAssoziationPO assoc = ((ObjectMappingRow)element).getAssociation();
                ICompIdentifierPO compId = assoc.getTechnicalName();
                return compId != null ? compId.getComponentName() : null;
            }
        });
        return column;
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        boolean isProjDeleted = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        TimestampBP.refreshTimestamp((ITimestampPO)objMap);
        try {
            try {
                if (this.getEditorHelper().isDirty()) {
                    EditSupport editSupport = this.getEditorHelper().getEditSupport();
                    IObjectMappingProfilePO origProfile = ((IAUTMainPO)editSupport.getOriginal()).getObjMap().getProfile();
                    IObjectMappingProfilePO workProfile = ((IAUTMainPO)editSupport.getWorkVersion()).getObjMap().getProfile();
                    IWritableComponentNameCache compNameCache = editSupport.getCompMapper().getCompNameCache();
                    HashSet<IComponentNamePO> renamedCompNames = new HashSet<IComponentNamePO>(compNameCache.getRenamedNames());
                    Set<IComponentNamePO> reuseChangedCompNames = this.getCompNamesWithChangedReuse(compNameCache);
                    this.fixCompNameReferences(this.getAut().getObjMap(), (IComponentNameCache)this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache());
                    editSupport.saveWorkVersion();
                    this.fireRenamedEvents(renamedCompNames);
                    this.fireReuseChangedEvents(reuseChangedCompNames);
                    if (this.getAut().equals(TestExecution.getInstance().getConnectedAut()) && !workProfile.equals(origProfile)) {
                        NagDialog.runNagDialog(Plugin.getActiveWorkbenchWindowShell(), "InfoNagger.ObjectMappingProfileChanged", "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
                    }
                }
                ComponentNamesBP.getInstance().init();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
                monitor.done();
                if (!isProjDeleted) {
                    this.getEditorHelper().setDirty(false);
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e2) {
                        PMExceptionHandler.handlePMExceptionForEditor(e2, this);
                    }
                }
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
                isProjDeleted = true;
                monitor.done();
                if (!isProjDeleted) {
                    this.getEditorHelper().setDirty(false);
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this);
                    }
                }
            }
            catch (IncompatibleTypeException ite) {
                Utils.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
                if (!isProjDeleted) {
                    this.getEditorHelper().setDirty(false);
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this);
                    }
                }
            }
        }
        finally {
            monitor.done();
            if (!isProjDeleted) {
                this.getEditorHelper().setDirty(false);
                try {
                    this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
            }
        }
    }

    private Set<IComponentNamePO> getCompNamesWithChangedReuse(IWritableComponentNameCache compNameCache) {
        HashSet<IComponentNamePO> reuseChangedCompNames = new HashSet<IComponentNamePO>();
        for (String compNameGuid : compNameCache.getReusedNames()) {
            IComponentNamePO compName = compNameCache.getCompNamePo(compNameGuid);
            if (compName == null) continue;
            reuseChangedCompNames.add(compName);
        }
        return reuseChangedCompNames;
    }

    private void fireReuseChangedEvents(Set<IComponentNamePO> reuseChangedCompNames) {
        for (IComponentNamePO compName : reuseChangedCompNames) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.ReuseChanged, DataEventDispatcher.UpdateState.all);
        }
    }

    private void fireRenamedEvents(Set<IComponentNamePO> renamedCompNames) {
        for (IComponentNamePO compName : renamedCompNames) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
        }
    }

    private boolean fixCompNameReferences(IObjectMappingPO objectMap, IComponentNameCache compNameCache) {
        boolean isChanged = false;
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            HashSet<String> guidsToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                IComponentNamePO compNamePo = compNameCache.getCompNamePo(compNameGuid);
                if (compNamePo == null || compNamePo.getGuid().equals(compNameGuid)) continue;
                guidsToRemove.add(compNameGuid);
            }
            for (String toRemove : guidsToRemove) {
                isChanged = true;
                assoc.removeLogicalName(toRemove);
            }
        }
        if (isChanged) {
            CompNamePM.removeUnusedCompNames((Long)GeneralStorage.getInstance().getProject().getId(), (EntityManager)this.getEditorHelper().getEditSupport().getSession());
        }
        return isChanged;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IAUTMainPO getAut() {
        return (IAUTMainPO)this.getEditorHelper().getEditSupport().getWorkVersion();
    }

    private void checkMasterSessionUpToDate() {
        IObjectMappingPO objMap = this.getAut().getObjMap();
        boolean isUpToDate = TimestampBP.refreshEditorNodeInMasterSession((ITimestampPO)objMap);
        if (!isUpToDate) {
            CompletenessBP.getInstance().handleDataChanged((IPersistentObject)objMap, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.notInEditor);
        }
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_OM_EDITOR_IMAGE;
    }

    @Override
    public Composite getParentComposite() {
        return this.getContainer().getParent();
    }

    @Override
    public void reOpenEditor(IPersistentObject obj) throws PMException {
        this.getEditorHelper().setDirty(false);
        Object[] expandedElements = this.m_treeViewer.getExpandedElements();
        this.getEditorHelper().getEditSupport().close();
        PersistableEditorInput input = new PersistableEditorInput(obj);
        try {
            this.init(this.getEditorSite(), input);
            this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
            this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
            this.m_treeViewerUpdater = new ComponentNameTreeViewerUpdater(this.m_treeViewer, (IComponentNameCache)this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache());
            ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)this.m_treeViewer, this.getCompMapper());
            this.m_treeViewer.setInput((Object)this.getAut().getObjMap());
            this.m_treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.m_tableViewer.setInput((Object)this.getAut().getObjMap());
            this.m_treeViewer.setExpandedElements(expandedElements);
            this.m_treeViewer.expandToLevel(2);
            HashMap<TreeViewer, IObjectMappingCategoryPO> viewerToInput = new HashMap<TreeViewer, IObjectMappingCategoryPO>();
            viewerToInput.put(this.m_compNameTreeViewer, this.getAut().getObjMap().getUnmappedLogicalCategory());
            viewerToInput.put(this.m_uiElementTreeViewer, this.getAut().getObjMap().getUnmappedTechnicalCategory());
            viewerToInput.put(this.m_mappedComponentTreeViewer, this.getAut().getObjMap().getMappedCategory());
            for (AbstractTreeViewer splitViewer : viewerToInput.keySet()) {
                Object[] expandedSplitViewerElements = splitViewer.getExpandedElements();
                ObjectMappingMultiPageEditor.setProviders(splitViewer, this.getCompMapper());
                splitViewer.setInput(viewerToInput.get(splitViewer));
                splitViewer.setExpandedElements(expandedSplitViewerElements);
                splitViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        catch (PartInitException partInitException) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
        this.m_mappingConfigComponent.setInput(this.getAut().getObjMap());
    }

    private static void setProviders(AbstractTreeViewer viewer, IWritableComponentNameMapper compNameMapper) {
        viewer.setContentProvider((IContentProvider)new OMEditorTreeContentProvider((IComponentNameMapper)compNameMapper));
        viewer.setLabelProvider((IBaseLabelProvider)new OMEditorTreeLabelProvider((IComponentNameMapper)compNameMapper));
    }

    public void setFocus() {
        if (this.getActivePage() == 0) {
            if (!this.m_compNameTreeViewer.getSelection().isEmpty()) {
                this.m_compNameTreeViewer.getControl().setFocus();
            } else if (!this.m_uiElementTreeViewer.getSelection().isEmpty()) {
                this.m_uiElementTreeViewer.getControl().setFocus();
            } else {
                this.m_mappedComponentTreeViewer.getControl().setFocus();
            }
        } else {
            super.setFocus();
        }
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    @Override
    public void fireDirtyProperty(boolean isDirty) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (i != this.getActivePage()) {
                if (i == 1) {
                    Object[] expandedElements = this.m_treeViewer.getExpandedElements();
                    this.m_treeViewer.setInput((Object)this.getAut().getObjMap());
                    this.m_treeViewer.refresh();
                    this.m_treeViewer.setExpandedElements(expandedElements);
                }
                if (i == 2) {
                    this.m_tableViewer.setInput((Object)this.getAut().getObjMap());
                    this.m_tableViewer.refresh();
                }
            }
            ++i;
        }
        this.firePropertyChange(257);
        if (!isDirty) {
            this.firePropertyChange(258);
        }
    }

    public void logicalNameAdded() {
        int i = 0;
        while (i < this.getPageCount()) {
            if (i == this.getActivePage()) {
                if (i == 1) {
                    this.m_treeViewer.refresh();
                }
                if (i == 2) {
                    this.m_tableViewer.refresh();
                }
            }
            ++i;
        }
    }

    @Override
    public JBEditorHelper getEditorHelper() {
        return this.m_editorHelper;
    }

    @Override
    public String getEditorPrefix() {
        return Messages.ObjectMappingEditorEditor;
    }

    @Override
    public void initTextAndInput(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(String.valueOf(this.getEditorPrefix()) + input.getName());
        this.getEditorSite().getActionBars().getMenuManager();
    }

    public void update(final int event, final Object obj) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                ObjectMappingMultiPageEditor.this.switchEvent(event, obj);
            }
        });
    }

    private void createNewTechnicalName(IComponentIdentifier component) {
        if (this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return;
        }
        IObjectMappingAssoziationPO techNameAssoc = this.getAut().getObjMap().addTechnicalName(component, this.getAut());
        if (techNameAssoc != null) {
            this.getEditorHelper().setDirty(true);
            if (this.m_omEditorBP.getCategoryToCreateIn() != null) {
                this.m_omEditorBP.getCategoryToCreateIn().addAssociation(techNameAssoc);
            } else {
                this.getAut().getObjMap().getUnmappedTechnicalCategory().addAssociation(techNameAssoc);
            }
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)techNameAssoc.getCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            this.m_tableViewer.refresh();
        }
        if (techNameAssoc == null) {
            for (IObjectMappingAssoziationPO assoc : this.getAut().getObjMap().getMappings()) {
                ICompIdentifierPO techName = assoc.getTechnicalName();
                if (techName == null || !techName.equals(component)) continue;
                techNameAssoc = assoc;
                break;
            }
        }
        if (techNameAssoc != null) {
            StructuredSelection techNameSelection = new StructuredSelection((Object)techNameAssoc);
            this.m_treeViewer.setSelection((ISelection)techNameSelection);
            this.m_uiElementTreeViewer.setSelection((ISelection)techNameSelection);
            this.m_mappedComponentTreeViewer.setSelection((ISelection)techNameSelection);
        }
    }

    private void switchEvent(int event, Object obj) {
        switch (event) {
            case 1: {
                IAUTMainPO aut = (IAUTMainPO)obj;
                if (this.getAut() != aut) break;
                this.cleanupNames();
                break;
            }
            case 2: {
                IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
                if (!this.getAut().equals(connectedAut)) break;
                IComponentIdentifier comp = (IComponentIdentifier)obj;
                this.createNewTechnicalName(comp);
            }
        }
    }

    @Override
    public void handleEditorDirtyStateChanged(IJBEditor gdEditor, boolean isDirty) {
        if (gdEditor == this) {
            this.m_revertEditorChangesAction.setEnabled(isDirty);
        }
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public OMEditorBP getOmEditorBP() {
        return this.m_omEditorBP;
    }

    public int cleanupNames() {
        this.m_componentNames = new HashSet<LogicComponent>();
        int addedItems = 0;
        HashSet<IObjectMappingAssoziationPO> addedNodes = new HashSet<IObjectMappingAssoziationPO>();
        for (ITestSuitePO ts : GeneralStorage.getInstance().getProject().getTestSuiteCont().getTestSuiteList()) {
            if (ts.getAut() == null || !ts.getAut().equals(this.getAut())) continue;
            CollectLogicalNamesOp op = new CollectLogicalNamesOp();
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            addedItems += op.getAddedNodeCount();
            addedNodes.addAll(op.getAddedNodes());
        }
        if (addedItems > 0) {
            this.getEditorHelper().setDirty(true);
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection(addedNodes.toArray()));
            }
        }
        if (!this.isDirty()) {
            try {
                this.getEditorHelper().getEditSupport().reinitializeEditSupport();
                this.getEditorHelper().resetEditableState();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
            }
        }
        return addedItems;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            ((IEditorPart)source).isDirty();
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.getEditorHelper().isDirty();
    }

    public void dispose() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
        IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
        if (AUTModeChangedCommand.getAutMode() == 2 && connectedAut != null && connectedAut.equals(this.getAut())) {
            TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            DataEventDispatcher.getInstance().fireOMStateChanged(DataEventDispatcher.OMState.notRunning);
        }
        ObjectMappingEventDispatcher.removeObserver((IObjectMappingObserver)this);
        this.getSite().setSelectionProvider(null);
        GuiEventDispatcher.getInstance().removeEditorDirtyStateListener(this);
        this.m_treeViewerUpdater = null;
        if (this.m_editorHelper != null) {
            this.m_editorHelper.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        if (this.m_editorHelper != null) {
            return this.m_editorHelper.getAdapter(adapter);
        }
        return null;
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        this.getEditorHelper().handleDataChanged(po, dataState, updateState);
        if (this.m_treeViewerUpdater != null) {
            this.m_treeViewerUpdater.handleDataChanged(po, dataState, updateState);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_editorHelper.init(site, input);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(newPageIndex));
        switch (newPageIndex) {
            case 0: 
            case 1: {
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_cutTreeItemAction);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_pasteTreeItemAction);
                break;
            }
            case 2: {
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
            }
            default: {
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), null);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
            }
        }
        this.getEditorSite().getActionBars().updateActionBars();
    }

    private IWritableComponentNameMapper getCompMapper() {
        return this.getEditorHelper().getEditSupport().getCompMapper();
    }

    @Override
    public TreeViewer getActiveTreeViewer() {
        return this.m_activeTreeViewer;
    }

    @Override
    public TreeViewer[] getTreeViewers() {
        return new TreeViewer[]{this.m_treeViewer, this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer};
    }

    public EntityManager getEntityManager() {
        return this.getEditorHelper().getEditSupport().getSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionListener
    implements ISelectionChangedListener {
        private ActionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (GeneralStorage.getInstance().getProject() == null || event.getSelection() == null || event.getSelection().isEmpty()) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(false);
                ObjectMappingMultiPageEditor.this.m_pasteTreeItemAction.setEnabled(false);
                return;
            }
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                this.enableCutAction(sel);
                this.enablePasteAction(sel);
            }
        }

        private void enableCutAction(IStructuredSelection sel) {
            boolean onlyCategoriesSelected = false;
            boolean categoryIsNotInSelList = false;
            boolean onlyMainCategoriesSelected = false;
            boolean mainCategoryIsNotInSelList = false;
            boolean techNamesSelected = false;
            boolean logicNamesSelected = false;
            if (sel != null && !sel.isEmpty()) {
                int selSize = sel.toList().size();
                int[] counter = SelectionChecker.selectionCounter(sel);
                onlyCategoriesSelected = counter[11] == selSize;
                categoryIsNotInSelList = counter[11] == 0;
                onlyMainCategoriesSelected = counter[12] == selSize;
                mainCategoryIsNotInSelList = counter[12] == 0;
                techNamesSelected = counter[9] > 0;
                boolean bl = logicNamesSelected = counter[10] > 0;
            }
            if (!categoryIsNotInSelList) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(false);
                return;
            }
            if (onlyMainCategoriesSelected) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(false);
                return;
            }
            if (onlyCategoriesSelected) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(true);
                return;
            }
            if (techNamesSelected && logicNamesSelected) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(false);
                return;
            }
            if (categoryIsNotInSelList && mainCategoryIsNotInSelList) {
                ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(true);
                return;
            }
            ObjectMappingMultiPageEditor.this.m_cutTreeItemAction.setEnabled(false);
        }

        private boolean getPasteActionEnablementForAssocs(List<IObjectMappingAssoziationPO> toMove, List<Object> targetList) {
            for (Object target : targetList) {
                if (target instanceof IObjectMappingCategoryPO) {
                    if (OMEditorDndSupport.canMoveAssociations(toMove, (IObjectMappingCategoryPO)target, ObjectMappingMultiPageEditor.this)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private boolean getPasteActionEnablementForCategories(List<IObjectMappingCategoryPO> toMove, List<Object> targetList) {
            for (Object target : targetList) {
                if (target instanceof IObjectMappingCategoryPO) {
                    if (OMEditorDndSupport.canMoveCategories(toMove, (IObjectMappingCategoryPO)target, ObjectMappingMultiPageEditor.this)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private boolean getPasteActionEnablementForCompNames(List<Object> targetList) {
            for (Object target : targetList) {
                if (target instanceof IObjectMappingAssoziationPO) {
                    return true;
                }
                if (target instanceof IObjectMappingCategoryPO) {
                    if (OMEditorDndSupport.canMoveCompNames((IObjectMappingCategoryPO)target, ObjectMappingMultiPageEditor.this)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private void enablePasteAction(IStructuredSelection sel) {
            ObjectMappingMultiPageEditor.this.m_pasteTreeItemAction.setEnabled(false);
            LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
            Object cbContents = ObjectMappingMultiPageEditor.this.getEditorHelper().getClipboard().getContents((Transfer)transfer);
            if (cbContents == null) {
                return;
            }
            if (transfer.getSource() != null && !transfer.getSource().equals(ObjectMappingMultiPageEditor.this.getTreeViewer())) {
                return;
            }
            boolean isEnabled = false;
            isEnabled = transfer.containsOnlyType(IObjectMappingAssoziationPO.class) ? this.getPasteActionEnablementForAssocs(transfer.getSelection().toList(), sel.toList()) : (transfer.containsOnlyType(IObjectMappingCategoryPO.class) ? this.getPasteActionEnablementForCategories(transfer.getSelection().toList(), sel.toList()) : (transfer.containsOnlyType(IComponentNamePO.class) ? this.getPasteActionEnablementForCompNames(sel.toList()) : false));
            ObjectMappingMultiPageEditor.this.m_pasteTreeItemAction.setEnabled(isEnabled);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectLogicalNamesOp
    implements ITreeNodeOperation<INodePO> {
        private int m_addedNodeCount = 0;
        private List<IObjectMappingAssoziationPO> m_addedNodes = new ArrayList<IObjectMappingAssoziationPO>();
        private CompNamesBP m_compNamesBP = new CompNamesBP();

        private CollectLogicalNamesOp() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (Hibernator.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
                ICapPO cap = (ICapPO)node;
                CompNameResult result = this.m_compNamesBP.findCompName(ctx.getCurrentTreePath(), (INodePO)cap, cap.getComponentName(), (IComponentNameCache)ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache());
                IComponentNamePO compNamePo = ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getCompNamePo(result.getCompName());
                if (compNamePo != null) {
                    LogicComponent logic = new LogicComponent(compNamePo.getName(), compNamePo.getComponentType());
                    if (!(cap.getMetaComponentType() instanceof ConcreteComponent && ((ConcreteComponent)cap.getMetaComponentType()).hasDefaultMapping() || ObjectMappingMultiPageEditor.this.m_omEditorBP.getAssociation(compNamePo.getGuid()) != null)) {
                        if (ObjectMappingMultiPageEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                            return true;
                        }
                        IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(null, new ArrayList());
                        try {
                            ObjectMappingMultiPageEditor.this.getCompMapper().changeReuse((IComponentNameReuser)assoc, null, compNamePo.getGuid());
                            ObjectMappingMultiPageEditor.this.getAut().getObjMap().getUnmappedLogicalCategory().addAssociation(assoc);
                            this.m_addedNodes.add(assoc);
                            ++this.m_addedNodeCount;
                        }
                        catch (IncompatibleTypeException e) {
                            Utils.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                        }
                        catch (PMException pme) {
                            LOG.error((Object)(String.valueOf(Messages.ErrorCollectingComponentNames) + "."), (Throwable)pme);
                        }
                    }
                    ObjectMappingMultiPageEditor.this.m_componentNames.add(logic);
                }
            }
            return true;
        }

        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        }

        public int getAddedNodeCount() {
            return this.m_addedNodeCount;
        }

        public List<IObjectMappingAssoziationPO> getAddedNodes() {
            return this.m_addedNodes;
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            ObjectMappingMultiPageEditor.this.m_treeSelection = (IStructuredSelection)event.getSelection();
            Object firstElement = ObjectMappingMultiPageEditor.this.m_treeSelection.getFirstElement();
            if (ObjectMappingMultiPageEditor.this.m_treeSelection.size() != 1) {
                OMSetCategoryToMapInto.setEnabled(false);
                return;
            }
            OMMarkInAutAction.setEnabled(firstElement instanceof IObjectMappingAssoziationPO && this.isOmmInAutStarted());
            if (firstElement instanceof IObjectMappingCategoryPO && this.isCorrectMainCategory((IObjectMappingCategoryPO)firstElement) && ObjectMappingMultiPageEditor.this.getAut().getObjMap().getUnmappedTechnicalCategory().equals(OMEditorDndSupport.getSection((IObjectMappingCategoryPO)firstElement)) && this.isOmmInAutStarted()) {
                OMSetCategoryToMapInto.setEnabled(true);
                return;
            }
            OMSetCategoryToMapInto.setEnabled(false);
        }

        private boolean isCorrectMainCategory(IObjectMappingCategoryPO firstElement) {
            IObjectMappingCategoryPO category = firstElement;
            while (category.getParent() != null) {
                category = category.getParent();
            }
            return category.equals(ObjectMappingMultiPageEditor.this.getAut().getObjMap().getUnmappedTechnicalCategory());
        }

        private boolean isOmmInAutStarted() {
            if (TestExecution.getInstance().getConnectedAut() != null) {
                switch (AUTModeChangedCommand.getAutMode()) {
                    case 2: {
                        if (!ObjectMappingMultiPageEditor.this.getAut().equals(TestExecution.getInstance().getConnectedAut())) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class NullSelectionProvider
    implements ISelectionProvider {
        private NullSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class OMTableEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public OMTableEditorActivationStrategy(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 5 || event.eventType == 2 || event.eventType == 4;
        }
    }

    private class ObjectMappingCompNameEditingSupport
    extends AbstractObjectMappingEditingSupport {
        public ObjectMappingCompNameEditingSupport(IComponentNameMapper compNameMapper, TableViewer viewer) {
            super(compNameMapper, viewer);
        }

        protected Object getValue(Object element) {
            ObjectMappingRow row = (ObjectMappingRow)element;
            int logicalNameIndex = row.getLogicalNameIndex();
            if (logicalNameIndex < 0) {
                return "";
            }
            return ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getName((String)row.getAssociation().getLogicalNames().get(logicalNameIndex));
        }

        protected void doSetValue(Object element, Object value) {
            boolean isSameValue;
            Object oldValue = this.getValue(element);
            boolean bl = oldValue == null ? value == null : (isSameValue = oldValue.equals(value));
            if (!isSameValue && value != null && value.toString().trim().length() > 0) {
                if (ObjectMappingMultiPageEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                    return;
                }
                ObjectMappingRow row = (ObjectMappingRow)element;
                IWritableComponentNameMapper mapper = ObjectMappingMultiPageEditor.this.getCompMapper();
                String oldGuid = mapper.getCompNameCache().getGuidForName(String.valueOf(oldValue));
                String newGuid = mapper.getCompNameCache().getGuidForName(value.toString());
                if (newGuid == null) {
                    String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                    newGuid = mapper.getCompNameCache().createComponentNamePO(value.toString(), compType, ComponentNamesBP.CompNameCreationContext.OBJECT_MAPPING).getGuid();
                }
                OMEditorDndSupport.checkAndSwapComponentNames(row.getAssociation(), oldGuid, newGuid, ObjectMappingMultiPageEditor.this);
            }
        }
    }

    private static class ObjectMappingTreeSorter
    extends ViewerSorter {
        private ObjectMappingTreeSorter() {
        }

        public int category(Object element) {
            if (element instanceof IObjectMappingCategoryPO) {
                return 0;
            }
            if (element instanceof IObjectMappingAssoziationPO) {
                return 1;
            }
            if (element instanceof IComponentNamePO) {
                return 2;
            }
            return super.category(element);
        }
    }
}

