/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.IRecordListener;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.commands.CAPRecordedCommand;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventHandlerContainer;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ObjectMappingManager;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.JubulaStateController;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.controllers.dnd.EventHandlerDropTargetListener;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.controllers.dnd.TCEditorDropTargetListener;
import org.eclipse.jubula.client.ui.dialogs.AddEventHandlerDialog;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.provider.contentprovider.EventHandlerContentProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.SelectionChecker;
import org.eclipse.jubula.client.ui.utils.UIIdentitiyElementComparer;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class TestCaseEditor
extends AbstractTestCaseEditor
implements IRecordListener {
    private static final int[] SASH_WEIGHT = new int[]{75, 25};
    private ObjectMappingManager m_objectMappingManager = new ObjectMappingManager();
    private TreeViewer m_eventHandlerTreeViewer;
    private TreeViewer m_currentTreeViewer;

    public void createPartControlImpl(Composite parent) {
        super.createPartControlImpl(parent);
        this.m_eventHandlerTreeViewer.setContentProvider((IContentProvider)new EventHandlerContentProvider());
        this.m_eventHandlerTreeViewer.getControl().setMenu(this.createContextMenu());
        ActionListener actionListener = new ActionListener();
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)actionListener);
        DecoratingLabelProvider ld = new DecoratingLabelProvider((ILabelProvider)new GeneralLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        ld.setDecorationContext((IDecorationContext)new AbstractJBEditor.JBEditorDecorationContext(this));
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)ld);
        this.getEventHandlerTreeViewer().addSelectionChangedListener((ISelectionChangedListener)actionListener);
        if (!Plugin.getDefault().anyDirtyStar()) {
            this.checkAndRemoveUnusedTestData();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        int returnCode;
        IPersistentObject inputTC = this.getEditorHelper().getEditSupport().getWorkVersion();
        ISpecTestCasePO recordTC = CAPRecordedCommand.getRecSpecTestCase();
        boolean isStillObserving = CAPRecordedCommand.isObserving();
        if (isStillObserving && inputTC.equals(recordTC) && (returnCode = this.showSaveInObservModeDialog()) == 0) {
            TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            DataEventDispatcher.getInstance().fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.notRunning);
            isStillObserving = false;
        }
        if (!isStillObserving) {
            try {
                this.m_objectMappingManager.saveMappings();
                this.refreshOMProfilesForAUTS();
                this.removeIncorrectCompNamePairsInExecTcs();
                super.doSave(monitor);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
            catch (IncompatibleTypeException ite) {
                Utils.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
            }
        }
    }

    private void removeIncorrectCompNamePairsInExecTcs() {
        INodePO workVersion = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(workVersion.getParentProjectId());
        List execTcRefs = NodePM.getExecTestCases((String)workVersion.getGuid(), parentProjectIds);
        HashSet<INodePO> lockedNodePOs = new HashSet<INodePO>();
        EntityManager editorSession = this.getEditorHelper().getEditSupport().getSession();
        for (IExecTestCasePO execTc : execTcRefs) {
            try {
                INodePO parentNode = execTc.getParentNode();
                INodePO editorSessionParentNode = (INodePO)editorSession.find(HibernateUtil.getClass((Object)parentNode), (Object)parentNode.getId());
                if (!LockManager.instance().lockPO(editorSession, (IPersistentObject)editorSessionParentNode, true)) continue;
                lockedNodePOs.add(editorSessionParentNode);
            }
            catch (PMDirtyVersionException pMDirtyVersionException) {
            }
            catch (PMObjectDeletedException pMObjectDeletedException) {}
        }
        for (INodePO node : lockedNodePOs) {
            CompNamesBP.removeIncorrectCompNamePairs((INodePO)node);
        }
    }

    private void refreshOMProfilesForAUTS() {
        EntityManager sess = GeneralStorage.getInstance().getMasterSession();
        for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            sess.refresh((Object)aut.getObjMap().getProfile());
        }
    }

    public String getEditorPrefix() {
        return Messages.PluginTC;
    }

    public void capRecorded(final ICapPO newCap, final IComponentIdentifier ci) {
        if (newCap == null) {
            Utils.createMessageDialog(MessageIDs.E_TEST_STEP_NOT_CREATED);
        } else {
            final IAUTMainPO recordAut = TestExecution.getInstance().getConnectedAut();
            Plugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (TestCaseEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                        return;
                    }
                    if (!ObjectMappingEventDispatcher.getObjMapTransient().existTechnicalName(ci)) {
                        String capComponentName = TestCaseEditor.this.m_objectMappingManager.addMapping(recordAut, ci, newCap.getComponentName());
                        newCap.setComponentName(capComponentName);
                    }
                    TestCaseEditor.this.getTreeViewer().refresh(false);
                    TestCaseEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newCap), true);
                    TestCaseEditor.this.getEditorHelper().setDirty(true);
                }
            });
        }
    }

    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_TC_EDITOR_IMAGE;
    }

    public void reOpenEditor(IPersistentObject node) throws PMException {
        this.m_objectMappingManager.clear();
        ((ISpecTestCasePO)node).setIsReused(null);
        super.reOpenEditor(node);
        if (node instanceof ISpecTestCasePO) {
            CAPRecordedCommand.setRecSpecTestCase((ISpecTestCasePO)((ISpecTestCasePO)node));
        }
    }

    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerSpecTestCaseEditorContextId");
    }

    private int showSaveInObservModeDialog() {
        MessageDialog dialog = new MessageDialog(Plugin.getShell(), Messages.SaveInObservationModeDialogTitle, null, Messages.SaveInObservationModeDialogQuestion, 3, new String[]{Messages.NewProjectDialogMessageButton0, Messages.NewProjectDialogMessageButton0}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode();
    }

    public ISelection getSelection() {
        if (this.m_currentTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.m_currentTreeViewer.getSelection();
    }

    protected void renameGUINode(IPersistentObject po) {
        super.renameGUINode(po);
        this.m_eventHandlerTreeViewer.refresh(true);
    }

    private void createEventHandlerPart(Composite parent) {
        Composite headLineComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        headLineComposite.setLayout((Layout)layout);
        Label headLine = new Label(headLineComposite, 0);
        headLine.setText(Messages.TestCaseEditorEHAreaHeadline);
        ControlDecorator.decorateInfo((Control)headLine, "GDControlDecorator.EventHandler", false);
        GridData ehTvGridData = new GridData();
        ehTvGridData.grabExcessHorizontalSpace = true;
        ehTvGridData.grabExcessVerticalSpace = true;
        ehTvGridData.horizontalAlignment = 4;
        ehTvGridData.verticalAlignment = 4;
        ehTvGridData.verticalSpan = 100;
        GridLayout ehTvLayout = new GridLayout(1, true);
        ehTvLayout.marginWidth = 0;
        ehTvLayout.marginHeight = 0;
        ehTvLayout.marginBottom = 0;
        ehTvLayout.marginTop = 0;
        this.m_eventHandlerTreeViewer = new TreeViewer(headLineComposite);
        this.m_eventHandlerTreeViewer.getTree().setLayout((Layout)ehTvLayout);
        this.m_eventHandlerTreeViewer.getTree().setLayoutData((Object)ehTvGridData);
        DecoratingLabelProvider lp = new DecoratingLabelProvider((ILabelProvider)new GeneralLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.m_eventHandlerTreeViewer.setLabelProvider((IBaseLabelProvider)lp);
        this.m_eventHandlerTreeViewer.setComparer((IElementComparer)new UIIdentitiyElementComparer());
        this.m_eventHandlerTreeViewer.setUseHashlookup(true);
        this.m_eventHandlerTreeViewer.getTree().addListener(3, (Listener)new MouseDownListener());
        JubulaStateController.getInstance().addSelectionListenerToSelectionService();
        this.firePropertyChange(258);
    }

    protected void addInternalSelectionListeners(ISelectionChangedListener editorSelectionChangedListener) {
        super.addInternalSelectionListeners(editorSelectionChangedListener);
        this.m_eventHandlerTreeViewer.addSelectionChangedListener(editorSelectionChangedListener);
    }

    protected void addDragAndDropSupport(int operations, Transfer[] transfers) {
        super.addDragAndDropSupport(operations, transfers);
        this.m_eventHandlerTreeViewer.addDropSupport(operations, transfers, (DropTargetListener)new EventHandlerDropTargetListener(this));
    }

    public TreeViewer getEventHandlerTreeViewer() {
        return this.m_eventHandlerTreeViewer;
    }

    public void addEventHandler(ISpecTestCasePO eventHandlerInput, ISpecTestCasePO evHandlerOwner) {
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        ISpecTestCasePO workSpecTcPO = (ISpecTestCasePO)editSupport.getWorkVersion();
        ISpecTestCasePO eventHandlerInputPO = eventHandlerInput;
        IEventExecTestCasePO eventHandlerPO = null;
        try {
            ISpecTestCasePO eventHandlerWorkV = (ISpecTestCasePO)editSupport.createWorkVersion((IPersistentObject)eventHandlerInputPO);
            eventHandlerPO = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)eventHandlerWorkV, (INodePO)workSpecTcPO);
            int status = this.openAddEventHandlerDlg((IEventHandlerContainer)evHandlerOwner, eventHandlerPO);
            if (status == 0) {
                editSupport.lockWorkVersion();
                TestCaseBP.addEventHandler((EditSupport)editSupport, (ISpecTestCasePO)workSpecTcPO, (IEventExecTestCasePO)eventHandlerPO);
                this.getEditorHelper().setDirty(true);
                this.getEventHandlerTreeViewer().refresh();
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)eventHandlerPO, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
            }
        }
        catch (InvalidDataException invalidDataException) {
            Utils.createMessageDialog(MessageIDs.E_DOUBLE_EVENT, null, new String[]{NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetail, (Object[])new Object[]{evHandlerOwner.getName(), I18n.getString((String)eventHandlerPO.getEventType())})});
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
    }

    private int openAddEventHandlerDlg(IEventHandlerContainer eventHandlerCont, final IEventExecTestCasePO eventHandler) {
        AddEventHandlerDialog dialog = new AddEventHandlerDialog(Plugin.getShell(), eventHandler.getSpecTestCase().getName(), eventHandlerCont);
        dialog.addListener(new AddEventHandlerDialog.Listener(){

            public void notifySelected(String eventType, String reentryType, Integer maxRetries) {
                String evType = (String)StringHelper.getInstance().getMap().get(eventType);
                TestCaseEditor.this.setEventHandlerProperties(eventHandler, evType, reentryType, maxRetries);
            }
        });
        int status = dialog.open();
        dialog.close();
        return status;
    }

    public void handlePropertyChanged(boolean isCompNameChanged) {
        super.handlePropertyChanged(isCompNameChanged);
        this.m_eventHandlerTreeViewer.refresh();
    }

    protected SashForm createSashForm(Composite parent) {
        SashForm form = super.createSashForm(parent);
        this.createEventHandlerPart((Composite)form);
        form.setWeights(SASH_WEIGHT);
        return form;
    }

    public void setInitialInput() {
        super.setInitialInput();
        this.m_eventHandlerTreeViewer.setContentProvider((IContentProvider)new EventHandlerContentProvider());
        ISpecTestCasePO workVersion = (ISpecTestCasePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        this.m_eventHandlerTreeViewer.setInput((Object)workVersion);
        this.m_eventHandlerTreeViewer.expandAll();
        this.m_eventHandlerTreeViewer.getTree().addFocusListener((FocusListener)new TreeFocusListener());
    }

    protected void initTopTreeViewer(INodePO root) {
        super.initTopTreeViewer(root);
        this.getMainTreeViewer().getTree().addFocusListener((FocusListener)new TreeFocusListener());
    }

    protected void refresh() {
        super.refresh();
        this.getEventHandlerTreeViewer().refresh();
    }

    protected void handleNodeAdded(INodePO addedNode) {
        super.handleNodeAdded(addedNode);
        if (addedNode instanceof IEventExecTestCasePO) {
            UINodeBP.setSelectionAndFocusToNode(addedNode, this.m_eventHandlerTreeViewer);
        }
    }

    protected DropTargetListener getViewerDropAdapter() {
        return new TCEditorDropTargetListener(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionListener
    implements ISelectionChangedListener {
        private ActionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            boolean topViewerEnabled = TestCaseEditor.this.m_currentTreeViewer == TestCaseEditor.this.getTreeViewer();
            boolean specIsNotInSelList = false;
            if (sel != null && !sel.isEmpty()) {
                int[] counter = SelectionChecker.selectionCounter(sel);
                specIsNotInSelList = counter[1] == 0;
            }
            TestCaseEditor.this.getInsertNewTCAction().setEnabled(specIsNotInSelList && topViewerEnabled);
            TestCaseEditor.this.getAddNewTCAction().setEnabled(topViewerEnabled);
            if (GeneralStorage.getInstance().getProject() == null || sel == null || sel.isEmpty()) {
                TestCaseEditor.this.getCutTreeItemAction().setEnabled(false);
                TestCaseEditor.this.getPasteTreeItemAction().setEnabled(false);
            } else {
                List selList = sel.toList();
                this.enableCutAction(selList);
                this.enablePasteAction(selList);
            }
        }

        private void enableCutAction(List<INodePO> selList) {
            TestCaseEditor.this.getCutTreeItemAction().setEnabled(true);
            for (INodePO node : selList) {
                if (node instanceof IExecTestCasePO || node instanceof ICapPO) continue;
                TestCaseEditor.this.getCutTreeItemAction().setEnabled(false);
                return;
            }
        }

        private void enablePasteAction(List<INodePO> selList) {
            TestCaseEditor.this.getPasteTreeItemAction().setEnabled(false);
            LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
            Object cbContents = TestCaseEditor.this.getEditorHelper().getClipboard().getContents((Transfer)transfer);
            if (cbContents == null) {
                return;
            }
            for (INodePO guiNode : selList) {
                if (guiNode != null && cbContents instanceof StructuredSelection && TCEditorDndSupport.validateDrop((Viewer)transfer.getSource(), (Viewer)TestCaseEditor.this.getTreeViewer(), transfer.getSelection(), guiNode, false)) continue;
                TestCaseEditor.this.getPasteTreeItemAction().setEnabled(false);
                return;
            }
            TestCaseEditor.this.getPasteTreeItemAction().setEnabled(true);
        }
    }

    private class MouseDownListener
    implements Listener {
        private MouseDownListener() {
        }

        public void handleEvent(Event event) {
            if (3 == event.type) {
                Tree tree = (Tree)event.widget;
                if (TestCaseEditor.this.getMainTreeViewer().getTree() == tree) {
                    TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.getMainTreeViewer();
                } else if (TestCaseEditor.this.m_eventHandlerTreeViewer.getTree() == tree) {
                    TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.m_eventHandlerTreeViewer;
                }
            }
        }
    }

    private class TreeFocusListener
    extends FocusAdapter {
        private TreeFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Tree tree = (Tree)e.getSource();
            if (TestCaseEditor.this.getMainTreeViewer().getTree() == tree) {
                TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.getMainTreeViewer();
            } else if (TestCaseEditor.this.m_eventHandlerTreeViewer.getTree() == tree) {
                TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.m_eventHandlerTreeViewer;
            }
            TestCaseEditor.this.m_currentTreeViewer.setSelection(TestCaseEditor.this.m_currentTreeViewer.getSelection(), true);
        }
    }
}

