/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.actions.SearchTreeAction;
import org.eclipse.jubula.client.ui.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.controllers.dnd.TJEditorDropTargetListener;
import org.eclipse.jubula.client.ui.controllers.dnd.TreeViewerContainerDragSourceListener;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.TestJobEditorContentProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;

public class TestJobEditor
extends AbstractJBEditor {
    public String getEditorPrefix() {
        return Messages.PluginTJ;
    }

    public void createPartControlImpl(Composite parent) {
        this.createMainPart(parent);
        GridData gridData = new GridData(1808);
        this.getMainTreeViewer().getControl().setLayoutData((Object)gridData);
        this.setControl(this.getMainTreeViewer().getControl());
        this.getMainTreeViewer().setContentProvider((IContentProvider)new TestJobEditorContentProvider());
        this.addDragAndDropSupport();
        this.getEditorHelper().addListeners();
        this.setActionHandlers();
        this.setInitialInput();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addPropertyChangedListener((DataEventDispatcher.IPropertyChangedListener)this, true);
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
    }

    public void setInitialInput() {
        INodePO root = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        try {
            this.getTreeViewer().getTree().getParent().setRedraw(false);
            this.getTreeViewer().setInput((Object)new INodePO[]{root});
            this.getTreeViewer().expandAll();
        }
        finally {
            this.getTreeViewer().getTree().getParent().setRedraw(true);
        }
    }

    protected void addDragAndDropSupport() {
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.getMainTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new TreeViewerContainerDragSourceListener(this.getTreeViewer()));
        this.getMainTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)new TJEditorDropTargetListener(this));
    }

    protected void fillContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowSpecification");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.OpenSpecification");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.delete");
        mgr.add(SearchTreeAction.getAction());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
    }

    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerTestJobEditorContextId");
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        try {
            try {
                EditSupport editSupport = this.getEditorHelper().getEditSupport();
                IPersistentObject perObj = editSupport.getWorkVersion();
                TimestampBP.refreshTimestamp((ITimestampPO)((ITimestampPO)perObj));
                editSupport.saveWorkVersion();
                this.getEditorHelper().resetEditableState();
                this.getEditorHelper().setDirty(false);
            }
            catch (IncompatibleTypeException pmce) {
                this.handlePMCompNameException(pmce);
                monitor.done();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                try {
                    this.reOpenEditor((IPersistentObject)((NodeEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException pMException) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
                monitor.done();
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_TJ_EDITOR_IMAGE;
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof INodePO) {
            TreeViewer tv = this.getTreeViewer();
            switch (dataState) {
                case Added: {
                    INodePO addedNode = (INodePO)po;
                    INodePO editorNode = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
                    if (editorNode.indexOf(addedNode) <= -1) break;
                    this.getTreeViewer().refresh();
                    this.getTreeViewer().expandAll();
                    UINodeBP.setSelectionAndFocusToNode(addedNode, tv);
                    break;
                }
                case Deleted: {
                    if (po instanceof IProjectPO) break;
                    this.getTreeViewer().refresh();
                    this.setFocus();
                    break;
                }
                case Renamed: {
                    this.renameGUINode(po);
                    break;
                }
                case StructureModified: {
                    if (this.handleStructureModified(po)) break;
                    return;
                }
                case ReuseChanged: {
                    break;
                }
                default: {
                    Assert.notReached();
                }
            }
            this.getEditorHelper().handleDataChanged(po, dataState, updateState);
        }
    }

    private boolean handleStructureModified(IPersistentObject po) {
        if (po instanceof ITestSuitePO) {
            ITestSuitePO testsuitePO = (ITestSuitePO)po;
            INodePO workVersion = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
            List refTestSuites = NodePM.getInternalRefTestSuites((String)testsuitePO.getGuid(), (long)testsuitePO.getParentProjectId());
            if (!refTestSuites.isEmpty() && TestJobEditor.containsWorkVersionReuses(workVersion, testsuitePO)) {
                if (Plugin.getActiveEditor() != this && this.isDirty()) {
                    Utils.createMessageDialog(MessageIDs.I_SAVE_AND_REOPEN_EDITOR, new Object[]{this.getTitle(), testsuitePO.getName()}, null);
                    return false;
                }
                try {
                    this.reOpenEditor(this.getEditorHelper().getEditSupport().getOriginal());
                }
                catch (PMException pMException) {
                    Utils.createMessageDialog(MessageIDs.E_REFRESH_FAILED, null, new String[]{Messages.ErrorMessageEDITOR_CLOSE});
                    this.getSite().getPage().closeEditor((IEditorPart)this, false);
                }
                return false;
            }
        }
        return true;
    }

    private static boolean containsWorkVersionReuses(INodePO root, ITestSuitePO ts) {
        Iterator it = root.getNodeListIterator();
        List childList = IteratorUtils.toList((Iterator)it);
        for (INodePO child : childList) {
            if (!(child instanceof IRefTestSuitePO)) continue;
            IRefTestSuitePO refTs = (IRefTestSuitePO)child;
            if (ts.getGuid().equals(refTs.getTestSuiteGuid())) {
                return true;
            }
            if (!TestJobEditor.containsWorkVersionReuses((INodePO)refTs, ts)) continue;
            return true;
        }
        return false;
    }
}

