/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.controllers.dnd.TSEditorDndSupport;
import org.eclipse.jubula.client.ui.controllers.dnd.TSEditorDropTargetListener;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.TestSuiteEditorContentProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TestSuiteEditor
extends AbstractTestCaseEditor {
    public void createPartControlImpl(Composite parent) {
        super.createPartControlImpl(parent);
        ActionListener actionListener = new ActionListener();
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)actionListener);
        if (!Plugin.getDefault().anyDirtyStar()) {
            this.checkAndRemoveUnusedTestData();
        }
    }

    public void setInitialInput() {
        this.getMainTreeViewer().setContentProvider((IContentProvider)new TestSuiteEditorContentProvider());
        ITestSuitePO rootPO = (ITestSuitePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        try {
            this.getTreeViewer().getTree().setRedraw(false);
            this.getTreeViewer().setInput((Object)new ITestSuitePO[]{rootPO});
        }
        finally {
            this.getTreeViewer().getTree().setRedraw(true);
            this.getMainTreeViewer().expandAll();
            this.getMainTreeViewer().setSelection((ISelection)new StructuredSelection((Object)rootPO));
        }
    }

    protected boolean checkCompleteness() {
        ITestSuitePO tsWorkVersion = (ITestSuitePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        if (!this.checkWorkingLanguage(tsWorkVersion)) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR, null, new String[]{Messages.TestCaseEditorUnsupportedAUTLanguage});
            return false;
        }
        if (tsWorkVersion.getName() == null || "".equals(tsWorkVersion.getName())) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR, null, new String[]{Messages.TestCaseEditorNoTsuiteName});
            return false;
        }
        if (tsWorkVersion.getName().startsWith(" ") || tsWorkVersion.getName().endsWith(" ")) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR, null, new String[]{Messages.TestCaseEditorWrongTsName});
            return false;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (!tsWorkVersion.getName().equals(this.getEditorHelper().getEditSupport().getOriginal().getName()) && ProjectPM.doesTestSuiteExists((Long)project.getId(), (String)tsWorkVersion.getName())) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR, null, new String[]{Messages.TestCaseEditorDoubleTsuiteName});
            return false;
        }
        if (tsWorkVersion.getStepDelay() == -1) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR, null, new String[]{Messages.TestSuiteEditorEmptyStepDelay});
            return false;
        }
        Iterator iter = tsWorkVersion.getNodeListIterator();
        while (iter.hasNext()) {
            IExecTestCasePO execTC;
            INodePO child = (INodePO)iter.next();
            if (!Hibernator.isPoSubclass((IPersistentObject)child, IExecTestCasePO.class) || this.checkExecTCCompleteness(execTC = (IExecTestCasePO)child)) continue;
            return false;
        }
        return true;
    }

    private boolean checkWorkingLanguage(ITestSuitePO tsWorkVersion) {
        Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
        if (tsWorkVersion.getAut() != null) {
            for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
                if (!aut.equals(tsWorkVersion.getAut())) continue;
                for (Locale autLang : aut.getLangHelper().getLanguageList()) {
                    if (!workLang.equals(autLang)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkExecTCCompleteness(IExecTestCasePO testCase) {
        Object[] tcName = new Object[]{testCase.getName()};
        String name = testCase.getName();
        if (name == null || "".equals(name)) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR_TC_EX, tcName, new String[]{Messages.TestCaseEditorNoExecTcName});
            return false;
        }
        if (testCase.getName().startsWith(" ") || testCase.getName().endsWith(" ")) {
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR_TC_EX, tcName, new String[]{Messages.TestCaseEditorWrongExecTcName});
            return false;
        }
        for (ICompNamesPairPO compNamesPair : testCase.getCompNamesPairs()) {
            if (compNamesPair.getSecondName().equals("")) {
                Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR_TC_EX, tcName, new String[]{String.valueOf(NLS.bind((String)Messages.TestCaseEditorCompNameError, (Object[])new Object[]{compNamesPair.getFirstName()})) + Messages.TestCaseEditorEmptyCompName});
                return false;
            }
            if (!compNamesPair.getSecondName().startsWith(" ") && !compNamesPair.getSecondName().endsWith(" ")) continue;
            Utils.createMessageDialog(MessageIDs.E_CANNOT_SAVE_EDITOR_TC_EX, tcName, new String[]{String.valueOf(NLS.bind((String)Messages.TestCaseEditorCompNameError, (Object[])new Object[]{compNamesPair.getFirstName()})) + Messages.TestCaseEditorWrongCompName});
            return false;
        }
        return true;
    }

    public String getEditorPrefix() {
        return Messages.PluginTS;
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.getStructuredSelection();
        mgr.add((IContributionItem)new GroupMarker("additions"));
        if (selection.getFirstElement() == null) {
            return;
        }
        MenuManager submenuAdd = new MenuManager(Messages.TestSuiteBrowserAdd, "org.eclipse.ui.AddSubMenu");
        MenuManager submenuRefactor = new MenuManager(Messages.TestCaseEditorRefactor, "org.eclipse.ui.RefactorSubMenu");
        MenuManager submenuInsert = new MenuManager(Messages.TestSuiteEditorInsert, "org.eclipse.ui.NewSubMenu");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.newTestCaseReference");
        mgr.add((IContributionItem)submenuAdd);
        mgr.add((IContributionItem)submenuInsert);
        mgr.add((IContributionItem)submenuRefactor);
        CommandHelper.createContributionPushItem((IMenuManager)submenuRefactor, "org.eclipse.jubula.client.ui.commands.ExtractTestCase");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.RevertChanges");
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.getCutTreeItemAction());
        mgr.add((IAction)this.getPasteTreeItemAction());
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ToggleActiveStatus");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.edit.delete");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.OpenSpecification");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ShowSpecification");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
    }

    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_TS_EDITOR_IMAGE;
    }

    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.testSuiteEditorContextId");
    }

    protected DropTargetListener getViewerDropAdapter() {
        return new TSEditorDropTargetListener(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionListener
    implements ISelectionChangedListener {
        private ActionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (GeneralStorage.getInstance().getProject() == null || sel == null || sel.isEmpty()) {
                TestSuiteEditor.this.getCutTreeItemAction().setEnabled(false);
                TestSuiteEditor.this.getPasteTreeItemAction().setEnabled(false);
            } else {
                List selList = sel.toList();
                this.enableCutAction(selList);
                this.enablePasteAction(selList);
            }
        }

        private void enableCutAction(List<INodePO> selList) {
            TestSuiteEditor.this.getCutTreeItemAction().setEnabled(true);
            for (INodePO node : selList) {
                if (node instanceof IExecTestCasePO || node instanceof ICapPO) continue;
                TestSuiteEditor.this.getCutTreeItemAction().setEnabled(false);
                return;
            }
        }

        private void enablePasteAction(List<INodePO> selList) {
            TestSuiteEditor.this.getPasteTreeItemAction().setEnabled(true);
            LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
            Object cbContents = TestSuiteEditor.this.getEditorHelper().getClipboard().getContents((Transfer)transfer);
            if (cbContents instanceof IStructuredSelection) {
                IStructuredSelection cbSelection = (IStructuredSelection)cbContents;
                for (INodePO guiNode : selList) {
                    if (guiNode != null && cbContents instanceof StructuredSelection && TSEditorDndSupport.validateDrop((Viewer)transfer.getSource(), (Viewer)TestSuiteEditor.this.getTreeViewer(), cbSelection, guiNode, false)) continue;
                    TestSuiteEditor.this.getPasteTreeItemAction().setEnabled(false);
                    return;
                }
            } else {
                TestSuiteEditor.this.getPasteTreeItemAction().setEnabled(false);
            }
        }
    }
}

