/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.EnterCommentDialog;
import org.eclipse.jubula.client.ui.handlers.AbstractTestResultViewHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddTestResultSummaryCommentHandler
extends AbstractTestResultViewHandler {
    public Object executeImpl(ExecutionEvent event) {
        ITestResultSummaryPO selectedSummary = this.getSelectedSummary(event);
        if (selectedSummary != null) {
            String origTitle = selectedSummary.getCommentTitle();
            String origDetail = selectedSummary.getCommentDetail();
            EnterCommentDialog dialog = new EnterCommentDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), new IValidator(){

                public IStatus validate(Object value) {
                    if (value instanceof String) {
                        return ((String)value).length() < 4000 ? Status.OK_STATUS : Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }, origTitle, origDetail);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testResultSummaryAddCommentContextId");
            int result = dialog.open();
            if (result != 0) {
                return null;
            }
            String newTitle = dialog.getCommentTitle();
            String newDetails = dialog.getCommentDetail();
            if (!StringUtils.equals((String)origTitle, (String)newTitle) || !StringUtils.equals((String)origDetail, (String)newDetails)) {
                this.performOperation(selectedSummary, newTitle, newDetails);
            }
        }
        return null;
    }

    private void performOperation(ITestResultSummaryPO selectedSummary, String newTitle, String newDetails) {
        EntityManager sess = Hibernator.instance().openSession();
        try {
            try {
                EntityTransaction tx = Hibernator.instance().getTransaction(sess);
                ITestResultSummaryPO transactionSummary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                transactionSummary.setCommentTitle(newTitle);
                transactionSummary.setCommentDetail(newDetails);
                Hibernator.instance().commitTransaction(sess, tx);
                ClientTestFactory.getClientTest().fireTestresultSummaryChanged();
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            Hibernator.instance().dropSession(sess);
        }
    }
}

