/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TreeOpsBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractTestCaseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractTestCaseEditor) {
            AbstractTestCaseEditor editor = (AbstractTestCaseEditor)activePart;
            if (editor.isDirty()) {
                Dialog editorDirtyDlg = Utils.createMessageDialog(MessageIDs.Q_SAVE_AND_EXTRACT);
                if (editorDirtyDlg.getReturnCode() != 0) {
                    return null;
                }
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            String extractedTCName = this.getNewName(editor);
            InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestCaseActionTCTitle, extractedTCName, Messages.NewTestCaseActionTCMessage, Messages.RenameActionTCLabel, Messages.RenameActionTCError, Messages.NewTestCaseActionDoubleTCName, "newTestCaseDialog.gif", Messages.NewTestCaseActionTCShell, false);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestcaseExtractContextId");
            dialog.open();
            int retCode = dialog.getReturnCode();
            String newTcName = dialog.getName();
            dialog.close();
            if (retCode != 0) {
                return null;
            }
            INodePO node = (INodePO)editor.getEditorHelper().getEditSupport().getOriginal();
            if (node != null) {
                if (editor.getTreeViewer().getSelection() instanceof IStructuredSelection) {
                    this.validateNode(node);
                    IStructuredSelection selection = (IStructuredSelection)editor.getTreeViewer().getSelection();
                    ExtractionReturn extractRet = this.performExtraction(newTcName, node, selection);
                    if (extractRet.getErrorMessage() != null) {
                        Utils.createMessageDialog(new JBException(extractRet.getErrorMessage(), MessageIDs.E_UNEXPECTED_EXCEPTION), null, new String[]{extractRet.getErrorMessage()});
                    }
                    try {
                        editor.reOpenEditor((IPersistentObject)node);
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, editor);
                    }
                }
            } else {
                Utils.createMessageDialog(new JBException(Messages.EditorWillBeClosed, MessageIDs.E_DELETED_TC), null, null);
                try {
                    GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                }
            }
        }
        return null;
    }

    private String getNewName(AbstractTestCaseEditor editor) {
        String execName;
        Object e;
        String newName = "New Test Case";
        IStructuredSelection cs = (IStructuredSelection)editor.getTreeViewer().getSelection();
        if (cs.size() == 1 && (e = cs.getFirstElement()) instanceof IExecTestCasePO && !StringUtils.isBlank((String)(execName = ((IExecTestCasePO)e).getName()))) {
            newName = execName;
        }
        return newName;
    }

    private void validateNode(INodePO node) {
        Assert.verify((node instanceof ISpecTestCasePO || node instanceof ITestSuitePO ? 1 : 0) != 0, (String)Messages.ExtractTestCaseOperateISpecTestCasePO);
    }

    private ExtractionReturn performExtraction(String newTcName, INodePO node, IStructuredSelection selection) {
        ArrayList<IParamNodePO> modNodes = new ArrayList<IParamNodePO>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            modNodes.add((IParamNodePO)it.next());
        }
        try {
            ExtractionReturn extractionRet = this.persistExtraction(node, newTcName, modNodes);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)extractionRet.getExecTestCasePO(), DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            ISpecTestCasePO newSpecTc = extractionRet.getExecTestCasePO().getSpecTestCase();
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTc, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            return extractionRet;
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
        return new ExtractionReturn();
    }

    private ExtractionReturn persistExtraction(final INodePO ownerNode, final String newTcName, final List<IParamNodePO> modNodes) throws PMException, ProjectDeletedException {
        final ExtractionReturn extractionRet = new ExtractionReturn();
        final ParamNameBPDecorator mapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        TransactionSupport.ITransactAction op = new TransactionSupport.ITransactAction(){

            public void run(EntityManager s) throws PMException, ProjectDeletedException {
                IExecTestCasePO obj = null;
                try {
                    Hibernator.instance().refreshPO(s, (IPersistentObject)ownerNode, LockModeType.PESSIMISTIC_WRITE);
                    ArrayList<IParamNodePO> nodesToRef = new ArrayList<IParamNodePO>();
                    this.getModNodesFromCurrentSession(s, nodesToRef);
                    IExecTestCasePO newExecTc = TreeOpsBP.extractTestCase((String)newTcName, (INodePO)ownerNode, nodesToRef, (EntityManager)s, (ParamNameBPDecorator)mapper);
                    extractionRet.setExecTestCasePO(newExecTc);
                    obj = newExecTc;
                    s.persist((Object)newExecTc);
                    ISpecTestCasePO newSpecTc = newExecTc.getSpecTestCase();
                    ExtractTestCaseHandler.this.registerParamNamesToSave(newSpecTc, mapper);
                    obj = newSpecTc;
                    s.merge((Object)newSpecTc);
                    mapper.persist(s, GeneralStorage.getInstance().getProject().getId());
                }
                catch (TreeOpsBP.TreeOpFailedException e) {
                    Utils.createMessageDialog((JBException)((Object)e), null, null);
                }
                catch (PersistenceException e) {
                    PersistenceManager.handleDBExceptionForMasterSession(obj, (PersistenceException)e);
                }
            }

            private void getModNodesFromCurrentSession(EntityManager s, List<IParamNodePO> nodesToRef) {
                for (IParamNodePO node : modNodes) {
                    IParamNodePO object = (IParamNodePO)s.find(HibernateUtil.getClass((Object)node), (Object)node.getId());
                    if (object == null) continue;
                    nodesToRef.add(object);
                }
            }
        };
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        new TransactionSupport(s).transact(op);
        mapper.updateStandardMapperAndCleanup(ownerNode.getParentProjectId());
        return extractionRet;
    }

    protected void registerParamNamesToSave(ISpecTestCasePO newSpecTc, ParamNameBPDecorator mapper) {
        for (IParamDescriptionPO desc : newSpecTc.getParameterList()) {
            mapper.registerParamDescriptions((ITcParamDescriptionPO)desc);
        }
    }

    private static class ExtractionReturn {
        private String m_errorMessage = null;
        private IExecTestCasePO m_execTestCasePO = null;

        private ExtractionReturn() {
        }

        public String getErrorMessage() {
            return this.m_errorMessage;
        }

        public IExecTestCasePO getExecTestCasePO() {
            return this.m_execTestCasePO;
        }

        public void setErrorMessage(String errorMessage) {
            this.m_errorMessage = errorMessage;
        }

        public void setExecTestCasePO(IExecTestCasePO execTestCasePO) {
            this.m_execTestCasePO = execTestCasePO;
        }
    }
}

