/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.HibernateUtil;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeComponentNameInViewHandler
extends AbstractMergeComponentNameHandler {
    public Object execute(ExecutionEvent event) {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            Set<IComponentNamePO> compNames = this.getComponentNames(structuredSel);
            IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
            if (selectedCompNamePo == null) {
                return null;
            }
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            EntityTransaction tx = Hibernator.instance().getTransaction(masterSession);
            HashSet<IComponentNamePO> inSessionCompNames = new HashSet<IComponentNamePO>();
            for (IComponentNamePO cn : compNames) {
                inSessionCompNames.add((IComponentNamePO)masterSession.find(HibernateUtil.getClass((Object)cn), (Object)cn.getId()));
            }
            this.performOperation(inSessionCompNames, selectedCompNamePo);
            try {
                Hibernator.instance().commitTransaction(masterSession, tx);
                this.fireChangeEvents(inSessionCompNames);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
        return null;
    }
}

