/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.AbstractTestResultViewHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class ToggleRelevanceHandler
extends AbstractTestResultViewHandler {
    public Object executeImpl(ExecutionEvent event) {
        ITestResultSummaryPO selectedSummary = this.getSelectedSummary(event);
        if (selectedSummary != null) {
            EntityManager sess = Hibernator.instance().openSession();
            try {
                try {
                    EntityTransaction tx = Hibernator.instance().getTransaction(sess);
                    ITestResultSummaryPO transactionSummary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                    transactionSummary.setTestsuiteRelevant(!transactionSummary.isTestsuiteRelevant());
                    Hibernator.instance().commitTransaction(sess, tx);
                    ClientTestFactory.getClientTest().fireTestresultSummaryChanged();
                }
                catch (PMException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
                }
                catch (ProjectDeletedException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
                }
            }
            finally {
                Hibernator.instance().dropSession(sess);
            }
        }
        return null;
    }
}

