/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import java.util.ArrayList;
import java.util.HashSet;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.handlers.delete.DeleteHandlerHelper;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteComponentNameInViewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            HashSet<IComponentNamePO> toDelete = new HashSet<IComponentNamePO>();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IComponentNamePO) {
                    toDelete.add((IComponentNamePO)obj);
                }
                ++n2;
            }
            ArrayList<String> itemNames = new ArrayList<String>();
            for (IComponentNamePO compName : toDelete) {
                itemNames.add(compName.getName());
            }
            if (DeleteHandlerHelper.confirmDelete(itemNames)) {
                EntityManager s = GeneralStorage.getInstance().getMasterSession();
                try {
                    EntityTransaction tx = Hibernator.instance().getTransaction(s);
                    Hibernator.instance().lockPOSet(s, toDelete);
                    for (IComponentNamePO compName : toDelete) {
                        s.remove(s.merge((Object)compName));
                    }
                    Hibernator.instance().commitTransaction(s, tx);
                    for (IComponentNamePO compName : toDelete) {
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
                        ComponentNamesBP.getInstance().removeComponentNamePO(compName.getGuid());
                    }
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                }
            }
        }
        return null;
    }
}

