/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCubeContPO;
import org.eclipse.jubula.client.ui.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTestDataManagerHandler
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor && currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            CentralTestDataEditor editor = (CentralTestDataEditor)activePart;
            if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            if (this.confirmDelete(structuredSelection)) {
                this.deleteSelection(editor, structuredSelection);
            }
        }
        return null;
    }

    protected String getName(Object obj) {
        if (obj instanceof IParameterInterfacePO) {
            return ((IParameterInterfacePO)obj).getName();
        }
        return super.getName(obj);
    }

    private void deleteSelection(CentralTestDataEditor editor, IStructuredSelection structuredSelection) {
        ITestDataCubeContPO cont = (ITestDataCubeContPO)editor.getEditorHelper().getEditSupport().getWorkVersion();
        ArrayList<String> reusedCubeList = new ArrayList<String>(0);
        for (IParameterInterfacePO td : structuredSelection) {
            if (!TestDataCubeBP.isCubeReused((IParameterInterfacePO)td)) continue;
            reusedCubeList.add(td.getName());
        }
        if (reusedCubeList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            for (String s : reusedCubeList) {
                sb.append(" ");
                sb.append("-");
                sb.append(" ");
                sb.append(s);
                sb.append("\n");
            }
            Utils.createMessageDialog(MessageIDs.I_REUSED_TDC, new Object[]{sb.toString()}, null);
        } else {
            for (IParameterInterfacePO td : structuredSelection) {
                cont.removeTestDataCube(td);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)td, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
            }
            editor.getEditorHelper().setDirty(true);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cont, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }
}

