/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.sourceprovider.ObjectMappingModeSourceProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerOMEditor
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection) || !(activePart instanceof ObjectMappingMultiPageEditor)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)activePart;
        if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return null;
        }
        Class<?> classType = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (classType == null) {
                classType = obj.getClass();
            }
            if (obj.getClass() != classType) {
                return null;
            }
            ++n2;
        }
        Object lastParent = null;
        if (selection.size() == 1) {
            lastParent = this.deleteSingleElement(selection.getFirstElement(), editor);
        } else if (selection.size() > 1) {
            lastParent = this.deleteMultipleElements(selection.toArray(), editor);
        }
        if (lastParent != null) {
            this.refreshViewer(editor, lastParent);
        }
        return null;
    }

    private Object deleteMultipleElements(Object[] toDelete, ObjectMappingMultiPageEditor editor) {
        boolean delete = false;
        IObjectMappingCategoryPO lastParent = null;
        delete = MessageDialog.openConfirm((Shell)Plugin.getShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText3);
        if (delete) {
            Object[] objectArray = toDelete;
            int n = toDelete.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node instanceof IComponentNamePO) {
                    lastParent = editor.getOmEditorBP().deleteCompName((IComponentNamePO)node);
                } else if (node instanceof IObjectMappingAssoziationPO) {
                    lastParent = editor.getOmEditorBP().deleteAssociation((IObjectMappingAssoziationPO)node);
                } else if (node instanceof IObjectMappingCategoryPO && !this.willAncestorBeDeleted((IObjectMappingCategoryPO)node, toDelete)) {
                    lastParent = editor.getOmEditorBP().deleteCategory((IObjectMappingCategoryPO)node);
                }
                editor.getEditorHelper().setDirty(true);
                ++n2;
            }
        }
        return lastParent;
    }

    private boolean willAncestorBeDeleted(IObjectMappingCategoryPO category, Object[] toDelete) {
        IObjectMappingCategoryPO ancestor = category;
        while (ancestor != null) {
            ancestor = ancestor.getParent();
            Object[] objectArray = toDelete;
            int n = toDelete.length;
            int n2 = 0;
            while (n2 < n) {
                Object possibleAncestor = objectArray[n2];
                if (ObjectUtils.equals((Object)ancestor, (Object)possibleAncestor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Object deleteSingleElement(Object toDelete, ObjectMappingMultiPageEditor editor) {
        boolean delete = false;
        IObjectMappingCategoryPO lastParent = null;
        if (toDelete instanceof IObjectMappingAssoziationPO) {
            delete = MessageDialog.openConfirm((Shell)Plugin.getShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText1);
            if (delete) {
                lastParent = editor.getOmEditorBP().deleteAssociation((IObjectMappingAssoziationPO)toDelete);
                editor.getEditorHelper().setDirty(true);
            }
        } else if (toDelete instanceof IComponentNamePO) {
            delete = MessageDialog.openConfirm((Shell)Plugin.getShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText2);
            if (delete) {
                lastParent = editor.getOmEditorBP().deleteCompName((IComponentNamePO)toDelete);
                editor.getEditorHelper().setDirty(true);
            }
        } else if (toDelete instanceof IObjectMappingCategoryPO && (delete = MessageDialog.openConfirm((Shell)Plugin.getShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText4))) {
            lastParent = editor.getOmEditorBP().deleteCategory((IObjectMappingCategoryPO)toDelete);
            editor.getEditorHelper().setDirty(true);
        }
        return lastParent;
    }

    private void refreshViewer(ObjectMappingMultiPageEditor editor, Object newSelection) {
        editor.getTreeViewer().refresh();
        if (newSelection != null) {
            this.checkCategoryToMapInto(editor);
            editor.getTreeViewer().setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    private void checkCategoryToMapInto(ObjectMappingMultiPageEditor editor) {
        ISelection sel = null;
        IObjectMappingCategoryPO categoryToMapInto = editor.getOmEditorBP().getCategoryToCreateIn();
        if (categoryToMapInto != null) {
            editor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)categoryToMapInto));
            sel = editor.getTreeViewer().getSelection();
        }
        if (sel == null || sel.isEmpty()) {
            editor.getOmEditorBP().setCategoryToCreateIn(null);
            ObjectMappingModeSourceProvider omsp = (ObjectMappingModeSourceProvider)AbstractJBSourceProvider.getSourceProviderInstance(null, "org.eclipse.jubula.client.ui.sourceprovider.ObjectMappingModeSourceProvider");
            if (editor.getAut().equals(TestExecution.getInstance().getConnectedAut()) && omsp != null && omsp.isRunning()) {
                String message = NLS.bind((String)Messages.TestExecutionContributorAUTStartedMapping, (Object[])new Object[]{Messages.TestExecutionContributorCatUnassigned});
                int icon = 5;
                Plugin.showStatusLine(icon, message);
            }
        }
    }
}

