/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.views.TestCaseBrowser;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTreeItemHandlerTCBrowser
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IStructuredSelection structuredSelection;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activePart instanceof TestCaseBrowser && currentSelection instanceof IStructuredSelection && this.confirmDelete(structuredSelection = (IStructuredSelection)currentSelection)) {
            this.deleteSelection(structuredSelection);
        }
        return null;
    }

    private void deleteSelection(IStructuredSelection selection) {
        HashSet<INodePO> set = new HashSet<INodePO>(selection.toList());
        HashSet<INodePO> topNodesToDelete = new HashSet<INodePO>();
        for (INodePO node : set) {
            if (this.containsParent(set, node)) continue;
            topNodesToDelete.add(node);
        }
        ArrayList<INodePO> nodesToDelete = new ArrayList<INodePO>();
        for (INodePO node : topNodesToDelete) {
            this.collectNodesToDelete(nodesToDelete, node);
        }
        Collections.reverse(nodesToDelete);
        ArrayList<Object> cmds = new ArrayList<Object>();
        ParamNameBPDecorator dec = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        for (INodePO node : nodesToDelete) {
            DeleteTreeItemHandlerTCBrowser.closeOpenEditor((IPersistentObject)node);
            if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTcPO = (ISpecTestCasePO)node;
                List execTestCases = NodePM.getInternalExecTestCases((String)specTcPO.getGuid(), (long)specTcPO.getParentProjectId());
                if (!this.allExecsFromList(nodesToDelete, execTestCases)) {
                    Utils.createMessageDialog(MessageIDs.I_REUSED_SPEC_TCS, DeleteTreeItemHandlerTCBrowser.createLocOfUseArray(specTcPO, execTestCases, nodesToDelete), null);
                    return;
                }
                dec.clearAllNames();
                cmds.add(new MultipleNodePM.DeleteTCHandle(specTcPO, dec));
            }
            if (node instanceof IEventExecTestCasePO) {
                cmds.add(new MultipleNodePM.DeleteEvHandle((IEventExecTestCasePO)node));
            }
            if (!(node instanceof ICategoryPO)) continue;
            cmds.add(new MultipleNodePM.DeleteCatHandle((ICategoryPO)node));
        }
        try {
            MultipleNodePM.getInstance().executeCommands(cmds, dec);
            for (INodePO node : topNodesToDelete) {
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
            }
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
    }

    private boolean allExecsFromList(List<INodePO> nodesToDelete, List<IExecTestCasePO> execTestCases) {
        if (execTestCases.isEmpty()) {
            return true;
        }
        for (IExecTestCasePO execTc : execTestCases) {
            INodePO parent = execTc instanceof IEventExecTestCasePO ? ((IEventExecTestCasePO)execTc).getParentNode() : execTc.getParentNode();
            if (nodesToDelete.contains(parent)) continue;
            return false;
        }
        return true;
    }

    private void collectNodesToDelete(List<INodePO> nodesToDelete, INodePO node) {
        ISpecTestCasePO specTcPO;
        nodesToDelete.add(node);
        if (node instanceof ICategoryPO) {
            Iterator iter = node.getNodeListIterator();
            while (iter.hasNext()) {
                this.collectNodesToDelete(nodesToDelete, (INodePO)iter.next());
            }
        } else if (node instanceof ISpecTestCasePO && !(specTcPO = (ISpecTestCasePO)node).getAllEventEventExecTC().isEmpty()) {
            nodesToDelete.addAll(specTcPO.getAllEventEventExecTC());
        }
    }

    private boolean containsParent(Set<INodePO> set, INodePO node) {
        INodePO parent = node.getParentNode();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    private static Object[] createLocOfUseArray(ISpecTestCasePO specTcPO, List<IExecTestCasePO> reusesSet, List<INodePO> nodesToDelete) {
        TreeSet<String> locations = new TreeSet<String>();
        for (IExecTestCasePO node : reusesSet) {
            INodePO parent = null;
            parent = Hibernator.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class) ? ((IEventExecTestCasePO)node).getParentNode() : node.getParentNode();
            if (parent == null || nodesToDelete.contains(parent)) continue;
            locations.add("- " + parent.getName() + "\n");
        }
        String list = "";
        for (String string : locations) {
            list = String.valueOf(list) + string;
        }
        return new Object[]{specTcPO.getName(), locations.size(), list};
    }
}

