/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.delete;

import javax.persistence.PersistenceException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerTCEditor
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor && currentSelection instanceof IStructuredSelection) {
            AbstractJBEditor tce = (AbstractJBEditor)activePart;
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            if (this.confirmDelete(structuredSelection)) {
                if (tce.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                    return null;
                }
                for (INodePO node : structuredSelection) {
                    try {
                        node.getParentNode().removeNode(node);
                        if (node.getId() != null) {
                            tce.getEditorHelper().getEditSupport().getSession().remove((Object)node);
                        }
                        tce.getEditorHelper().setDirty(true);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
                    }
                    catch (PersistenceException e) {
                        try {
                            PersistenceManager.handleDBExceptionForEditor((IPersistentObject)node, (PersistenceException)e, (EditSupport)tce.getEditorHelper().getEditSupport());
                        }
                        catch (PMException pme) {
                            PMExceptionHandler.handlePMExceptionForMasterSession(pme);
                        }
                        break;
                    }
                }
            }
        }
        return null;
    }
}

