/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.project;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.core.preferences.database.H2ConnectionInfo;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.DBLoginDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.ui.PlatformUI;

public class SelectDatabaseHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(SelectDatabaseHandler.class);

    public Object execute(ExecutionEvent event) {
        IStatus returnStatus = Status.CANCEL_STATUS;
        boolean performLogin = false;
        String userName = "";
        String pwd = "";
        DatabaseConnectionInfo dbInfo = null;
        List availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
        if (availableConnections.size() == 1 && ((DatabaseConnection)availableConnections.get(0)).getConnectionInfo() instanceof H2ConnectionInfo) {
            dbInfo = ((DatabaseConnection)availableConnections.get(0)).getConnectionInfo();
            userName = dbInfo.getProperty("javax.persistence.jdbc.user");
            pwd = dbInfo.getProperty("javax.persistence.jdbc.password");
            performLogin = true;
        } else {
            DBLoginDialog dialog = new DBLoginDialog(Plugin.getShell());
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                userName = dialog.getUser();
                pwd = dialog.getPwd();
                dbInfo = dialog.getDatabaseConnection().getConnectionInfo();
                performLogin = true;
            }
        }
        if (performLogin) {
            try {
                returnStatus = this.connectToDatabase(userName, pwd, dbInfo);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        Hibernator.setUser(null);
        Hibernator.setPw(null);
        return returnStatus;
    }

    private IStatus connectToDatabase(final String username, final String pwd, final DatabaseConnectionInfo info) throws InterruptedException {
        final AtomicReference<IStatus> returnStatus = new AtomicReference<IStatus>(Status.CANCEL_STATUS);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.PluginConnectProgress, -1);
                    Utils.clearClient(true);
                    Hibernator.setUser((String)username);
                    Hibernator.setPw((String)pwd);
                    Hibernator.setDbConnectionName((DatabaseConnectionInfo)info);
                    if (Hibernator.instance() != null) {
                        CompNamePM.dispose();
                        GeneralStorage.getInstance().dispose();
                        if (LockManager.isRunning()) {
                            LockManager.instance().dispose();
                        }
                        Hibernator.instance().dispose();
                    }
                    if (Hibernator.init()) {
                        LockManager.instance();
                        Plugin.getDefault().writeLineToConsole(Messages.SelectDatabaseConnectSuccessful, true);
                        returnStatus.set(Status.OK_STATUS);
                    } else {
                        Plugin.getDefault().writeLineToConsole(Messages.SelectDatabaseConnectFailed, true);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            log.error((Object)ite.getCause(), ite.getCause());
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        return returnStatus.get();
    }
}

