/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.dialogs.DatabaseConnectionDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnectionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final GridDataFactory BUTTON_DATA_FACTORY = GridDataFactory.fillDefaults().align(4, 1);
    private static final Listener SELECT_ALL_LISTENER = new Listener(){
        private boolean m_isTraversing = false;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    if (!this.m_isTraversing) break;
                    this.m_isTraversing = false;
                    if (!(event.widget instanceof JBText)) break;
                    ((JBText)event.widget).selectAll();
                    break;
                }
                case 16: {
                    if (!(event.widget instanceof Text)) break;
                    ((Text)event.widget).clearSelection();
                    break;
                }
                case 31: {
                    if (!event.doit) break;
                    this.m_isTraversing = true;
                    break;
                }
            }
        }
    };
    private IObservableList m_connectionList;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.jubula.client.core"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.m_connectionList = new WritableList(DatabaseConnectionPreferencePage.parsePreferences(this.getPreferenceStore()), DatabaseConnection.class);
        ListViewer connectionViewer = new ListViewer(composite);
        Control listControl = connectionViewer.getControl();
        GridDataFactory.fillDefaults().grab(true, true).span(1, 3).hint(-1, -1).applyTo(listControl);
        ViewerSupport.bind((StructuredViewer)connectionViewer, (IObservableList)this.m_connectionList, (IValueProperty)BeanProperties.value((String)"name"));
        this.createAddButton(composite, this.m_connectionList);
        this.createRemoveButton(composite, this.m_connectionList, connectionViewer);
        this.createEditButton(composite, connectionViewer);
        return composite;
    }

    private void createEditButton(Composite parent, final ListViewer connectionViewer) {
        final IDoubleClickListener editListener = new IDoubleClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doubleClick(DoubleClickEvent event) {
                Object selectedObj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedObj instanceof DatabaseConnection) {
                    DatabaseConnection selectedConn = (DatabaseConnection)selectedObj;
                    try {
                        DatabaseConnectionDialog databaseConnectionWizard = new DatabaseConnectionDialog(new DatabaseConnection(selectedConn));
                        if (DatabaseConnectionPreferencePage.showDialog(databaseConnectionWizard, event.getViewer().getControl().getDisplay()) != 0) return;
                        DatabaseConnection modifiedConn = databaseConnectionWizard.getEditedConnection();
                        selectedConn.setName(modifiedConn.getName());
                        selectedConn.setConnectionInfo(modifiedConn.getConnectionInfo());
                        return;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    if (selectedObj == null) return;
                    throw new RuntimeException(Messages.DatabaseConnectionPrefPageSelecObjIsOfIncorrectType);
                }
            }
        };
        connectionViewer.addDoubleClickListener(editListener);
        final Button editButton = new Button(parent, 0);
        BUTTON_DATA_FACTORY.applyTo((Control)editButton);
        editButton.setEnabled(false);
        connectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                editButton.setEnabled(sel.size() == 1);
            }
        });
        editButton.setText(Messages.DatabaseConnectionPreferencePageEditButtonLabel);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                editListener.doubleClick(new DoubleClickEvent((Viewer)connectionViewer, connectionViewer.getSelection()));
            }
        });
    }

    private static int showDialog(DatabaseConnectionDialog databaseConnectionWizard, Display display) {
        WizardDialog dialog = new WizardDialog(Plugin.getShell(), (IWizard)databaseConnectionWizard){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button finishButton = this.getButton(16);
                finishButton.setText(IDialogConstants.OK_LABEL);
            }
        };
        databaseConnectionWizard.setWindowTitle(Messages.DatabaseConnectionDialogTitle);
        dialog.setHelpAvailable(true);
        display.addFilter(15, SELECT_ALL_LISTENER);
        display.addFilter(16, SELECT_ALL_LISTENER);
        display.addFilter(31, SELECT_ALL_LISTENER);
        try {
            int n = dialog.open();
            return n;
        }
        finally {
            display.removeFilter(15, SELECT_ALL_LISTENER);
            display.removeFilter(16, SELECT_ALL_LISTENER);
            display.removeFilter(31, SELECT_ALL_LISTENER);
        }
    }

    private void createRemoveButton(Composite parent, final IObservableList existingConnections, final ListViewer connectionViewer) {
        final Button removeButton = new Button(parent, 0);
        BUTTON_DATA_FACTORY.applyTo((Control)removeButton);
        removeButton.setEnabled(false);
        connectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.setText(Messages.DatabaseConnectionPreferencePageRemoveButtonLabel);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                existingConnections.removeAll((Collection)((IStructuredSelection)connectionViewer.getSelection()).toList());
            }
        });
    }

    private void createAddButton(Composite parent, final IObservableList existingConnections) {
        Button addButton = new Button(parent, 0);
        BUTTON_DATA_FACTORY.applyTo((Control)addButton);
        addButton.setText(Messages.DatabaseConnectionPreferencePageAddButtonLabel);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatabaseConnectionDialog databaseConnectionWizard = new DatabaseConnectionDialog();
                if (DatabaseConnectionPreferencePage.showDialog(databaseConnectionWizard, event.display) == 0) {
                    existingConnections.add((Object)databaseConnectionWizard.getEditedConnection());
                }
            }
        });
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.jubula.client.preference.databaseConnections", DatabaseConnectionConverter.convert((DatabaseConnection[])((DatabaseConnection[])this.m_connectionList.toArray((Object[])new DatabaseConnection[this.m_connectionList.size()]))));
        return super.performOk();
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault("org.eclipse.jubula.client.preference.databaseConnections");
        this.m_connectionList.clear();
        this.m_connectionList.addAll(DatabaseConnectionPreferencePage.parsePreferences(this.getPreferenceStore()));
        super.performDefaults();
    }

    private static List<DatabaseConnection> parsePreferences(IPreferenceStore prefStore) {
        return DatabaseConnectionConverter.convert((String)prefStore.getString("org.eclipse.jubula.client.preference.databaseConnections"));
    }
}

