/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.propertytester;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.businessprocess.ComponentNameReuseBP;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.osgi.util.NLS;

public class ComponentNamePropertyTester
extends PropertyTester {
    public static final String IS_BEING_USED_PROP = "isBeingUsed";
    public static final String IS_DEFAULT_MAPPING_PROP = "isDefaultMapping";
    private static final Log LOG = LogFactory.getLog(ComponentNamePropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IComponentNamePO) {
            IComponentNamePO compName = (IComponentNamePO)receiver;
            if (property.equals(IS_BEING_USED_PROP)) {
                boolean expectedBoolean;
                boolean isBeingUsed = this.testIsBeingUsed(compName);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return isBeingUsed == expectedBoolean;
            }
            if (property.equals(IS_DEFAULT_MAPPING_PROP)) {
                boolean expectedBoolean;
                boolean isDefaultMapping = this.testIsDefaultMapping(compName);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return isDefaultMapping == expectedBoolean;
            }
            LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterPropertyNotSupported, (Object[])new String[]{property}));
            return false;
        }
        String receiverClass = receiver != null ? receiver.getClass().getName() : "null";
        LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object[])new String[]{receiverClass}));
        return false;
    }

    private boolean testIsBeingUsed(IComponentNamePO compName) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            return ComponentNameReuseBP.getInstance().isCompNameReused(compName.getGuid());
        }
        return true;
    }

    private boolean testIsDefaultMapping(IComponentNamePO compName) {
        String name = compName.getName();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        return compSystem.getDefaultMappingNames().containsKey(name);
    }
}

