/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.propertytester;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class GuiNodePropertyTester
extends PropertyTester {
    public static final String EDITABLE_PROP = "isEditable";
    private static final Log LOG = LogFactory.getLog(GuiNodePropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof INodePO) {
            INodePO guiNode = (INodePO)receiver;
            if (property.equals(EDITABLE_PROP)) {
                boolean expectedBoolean;
                boolean isEditable = this.testIsEditable(guiNode);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return isEditable == expectedBoolean;
            }
            LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterPropertyNotSupported, (Object[])new String[]{property}));
            return false;
        }
        String receiverClass = receiver != null ? receiver.getClass().getName() : "null";
        LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object[])new String[]{receiverClass}));
        return false;
    }

    private boolean testIsEditable(INodePO node) {
        return NodeBP.isEditable((INodePO)node);
    }
}

