/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.propertytester;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class ObjectMappingCategoryPropertyTester
extends PropertyTester {
    public static final String IS_TOP_LEVEL = "isTopLevel";
    public static final String IS_EMPTY = "isEmpty";
    private static final Log LOG = LogFactory.getLog(ObjectMappingCategoryPropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IObjectMappingCategoryPO) {
            IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)receiver;
            if (property.equals(IS_TOP_LEVEL)) {
                boolean expectedBoolean;
                boolean areSameType = this.testIsTopLevel(category);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return areSameType == expectedBoolean;
            }
            if (property.equals(IS_EMPTY)) {
                boolean expectedBoolean;
                boolean isEmpty = this.testEmpty(category);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return isEmpty == expectedBoolean;
            }
            LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterPropertyNotSupported, (Object[])new String[]{property}));
            return false;
        }
        String receiverClass = receiver != null ? receiver.getClass().getName() : "null";
        LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object[])new String[]{receiverClass}));
        return false;
    }

    private boolean testIsTopLevel(IObjectMappingCategoryPO category) {
        return category.getParent() == null;
    }

    private boolean testEmpty(IObjectMappingCategoryPO category) {
        return category.getUnmodifiableAssociationList().isEmpty() && category.getUnmodifiableCategoryList().isEmpty();
    }
}

