/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.propertytester;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class PersistentObjectPropertyTester
extends PropertyTester {
    public static final String IS_IN_CUR_PROJECT = "isInCurrentProject";
    private static final Log LOG = LogFactory.getLog(PersistentObjectPropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IPersistentObject) {
            IPersistentObject po = (IPersistentObject)receiver;
            if (property.equals(IS_IN_CUR_PROJECT)) {
                boolean expectedBoolean;
                boolean isInCurrentProject = this.testIsInCurrentProject(po);
                boolean bl = expectedBoolean = expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
                return isInCurrentProject == expectedBoolean;
            }
            LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterPropertyNotSupported, (Object[])new String[]{property}));
            return false;
        }
        String receiverClass = receiver != null ? receiver.getClass().getName() : "null";
        LOG.warn((Object)NLS.bind((String)Messages.PropertyTesterTypeNotSupported, (Object[])new String[]{receiverClass}));
        return false;
    }

    private boolean testIsInCurrentProject(IPersistentObject po) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null && po.getParentProjectId() != null) {
            return po.getParentProjectId().equals(currentProject.getId());
        }
        return false;
    }
}

