/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.contentprovider;

import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobContPO;
import org.eclipse.jubula.client.core.model.ITestSuiteContPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.provider.contentprovider.AbstractTreeViewContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteBrowserContentProvider
extends AbstractTreeViewContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteBrowserContentProvider.class);

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProjectPO[]) {
            return new Object[]{((IProjectPO[])parentElement)[0]};
        }
        if (parentElement instanceof IProjectPO) {
            IProjectPO project = (IProjectPO)parentElement;
            return new Object[]{project.getTestJobCont(), project.getTestSuiteCont()};
        }
        if (parentElement instanceof IExecTestCasePO) {
            ISpecTestCasePO referencedTestCase = ((IExecTestCasePO)parentElement).getSpecTestCase();
            if (referencedTestCase != null) {
                return ArrayUtils.addAll((Object[])Collections.unmodifiableCollection(referencedTestCase.getAllEventEventExecTC()).toArray(), (Object[])referencedTestCase.getUnmodifiableNodeList().toArray());
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parentElement instanceof ITestSuitePO) {
            ITestSuitePO testSuite = (ITestSuitePO)parentElement;
            Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(workLang, testSuite)) {
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
        }
        if (parentElement instanceof INodePO) {
            return ((INodePO)parentElement).getUnmodifiableNodeList().toArray();
        }
        if (parentElement instanceof ITestSuiteContPO) {
            return ((ITestSuiteContPO)parentElement).getTestSuiteList().toArray();
        }
        if (parentElement instanceof ITestJobContPO) {
            return ((ITestJobContPO)parentElement).getTestJobList().toArray();
        }
        LOG.error("Wrong type for parent element: " + parentElement);
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

