/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.contentprovider.objectmapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.tools.exception.Assert;

public class OMEditorTreeContentProvider
extends AbstractTreeViewContentProvider {
    private Map<Object, Object> m_childToParentMap = new HashMap<Object, Object>();
    private IComponentNameMapper m_compNameMapper;
    private DataEventDispatcher.IDataChangedListener m_modelListener;

    public OMEditorTreeContentProvider(IComponentNameMapper compNameMapper) {
        this.m_compNameMapper = compNameMapper;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IObjectMappingPO) {
            IObjectMappingPO mapping = (IObjectMappingPO)parentElement;
            ArrayList<IObjectMappingCategoryPO> categoryList = new ArrayList<IObjectMappingCategoryPO>();
            categoryList.add(mapping.getMappedCategory());
            categoryList.add(mapping.getUnmappedLogicalCategory());
            categoryList.add(mapping.getUnmappedTechnicalCategory());
            Validate.noNullElements(categoryList);
            return categoryList.toArray();
        }
        if (parentElement instanceof IObjectMappingAssoziationPO) {
            IObjectMappingAssoziationPO assoc = (IObjectMappingAssoziationPO)parentElement;
            List componentNameGuidList = assoc.getLogicalNames();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String compNameGuid : componentNameGuidList) {
                IComponentNamePO compNamePo = this.m_compNameMapper.getCompNameCache().getCompNamePo(compNameGuid);
                if (compNamePo != null) {
                    arrayList.add(compNamePo);
                    this.m_childToParentMap.put(compNamePo, parentElement);
                    continue;
                }
                arrayList.add(compNameGuid);
                this.m_childToParentMap.put(compNamePo, parentElement);
            }
            Validate.noNullElements(arrayList);
            return arrayList.toArray();
        }
        if (parentElement instanceof IComponentNamePO) {
            return new Object[0];
        }
        if (parentElement instanceof IObjectMappingCategoryPO) {
            ArrayList<Object> childList = new ArrayList<Object>();
            IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)parentElement;
            childList.addAll(category.getUnmodifiableCategoryList());
            for (IObjectMappingAssoziationPO iObjectMappingAssoziationPO : category.getUnmodifiableAssociationList()) {
                if (iObjectMappingAssoziationPO.getTechnicalName() != null) {
                    childList.add(iObjectMappingAssoziationPO);
                    continue;
                }
                for (String compNameGuid : iObjectMappingAssoziationPO.getLogicalNames()) {
                    IComponentNamePO compName = this.m_compNameMapper.getCompNameCache().getCompNamePo(compNameGuid);
                    if (compName == null) continue;
                    childList.add(compName);
                }
            }
            for (Object e : childList) {
                this.m_childToParentMap.put(e, parentElement);
            }
            Validate.noNullElements(childList);
            return childList.toArray();
        }
        if (parentElement instanceof String) {
            return new Object[0];
        }
        Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfElement) + "!"));
        return new Object[0];
    }

    public Object getParent(Object element) {
        IObjectMappingCategoryPO parent;
        if (element instanceof IObjectMappingAssoziationPO) {
            return ((IObjectMappingAssoziationPO)element).getCategory();
        }
        if (element instanceof IObjectMappingCategoryPO && (parent = ((IObjectMappingCategoryPO)element).getParent()) != null) {
            return parent;
        }
        return this.m_childToParentMap.get(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.m_childToParentMap.clear();
        super.dispose();
    }

    public void inputChanged(final Viewer viewer, Object oldInput, final Object newInput) {
        Validate.isTrue((boolean)(viewer instanceof TreeViewer));
        this.m_childToParentMap.clear();
        if (this.m_modelListener != null) {
            DataEventDispatcher.getInstance().removeDataChangedListener(this.m_modelListener);
            this.m_modelListener = null;
        }
        if (newInput != null) {
            this.m_modelListener = new DataEventDispatcher.IDataChangedListener(){

                public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
                    if (updateState != DataEventDispatcher.UpdateState.notInEditor) {
                        StructuredViewer structuredViewer = (StructuredViewer)viewer;
                        if (dataState == DataEventDispatcher.DataState.StructureModified) {
                            boolean objectsAreEqual;
                            boolean bl = objectsAreEqual = structuredViewer.getComparer() != null ? structuredViewer.getComparer().equals(newInput, (Object)po) : newInput.equals(po);
                            if (objectsAreEqual || po instanceof IAUTMainPO || po instanceof IObjectMappingPO) {
                                structuredViewer.refresh();
                            } else {
                                structuredViewer.refresh((Object)po);
                            }
                        } else if (dataState == DataEventDispatcher.DataState.Renamed) {
                            structuredViewer.update((Object)po, null);
                        }
                    }
                }
            };
            DataEventDispatcher.getInstance().addDataChangedListener(this.m_modelListener, true);
        }
    }
}

