/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.labelprovider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.swt.graphics.Image;

public class TestResultTreeViewLabelProvider
extends LabelProvider {
    private static Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

    public void dispose() {
        Iterator<Image> i = imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        imageCache.clear();
    }

    public Image getImage(Object element) {
        TestResultNode resultTest = (TestResultNode)element;
        INodePO node = resultTest.getNode();
        Image image = null;
        Class nodePoClass = Hibernator.getClass((Object)node);
        if (Hibernator.isPoClassSubclass((Class)nodePoClass, ITestSuitePO.class)) {
            image = IconConstants.TS_IMAGE;
        } else if (Hibernator.isPoClassSubclass((Class)nodePoClass, ISpecTestCasePO.class)) {
            image = IconConstants.TC_IMAGE;
        }
        if (Hibernator.isPoClassSubclass((Class)nodePoClass, IExecTestCasePO.class)) {
            image = Hibernator.isPoClassSubclass((Class)nodePoClass, IEventExecTestCasePO.class) ? IconConstants.RESULT_EH_IMAGE : IconConstants.TC_IMAGE;
        }
        if (Hibernator.isPoClassSubclass((Class)nodePoClass, ICapPO.class)) {
            TestResultNode parent = resultTest.getParent();
            image = Hibernator.isPoSubclass((IPersistentObject)parent.getNode(), IEventExecTestCasePO.class) ? IconConstants.EH_CAP_IMAGE : IconConstants.CAP_IMAGE;
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof TestResultNode) {
            TestResultNode resultTest = (TestResultNode)element;
            String name = resultTest.getName();
            if (name != null) {
                return name;
            }
            INodePO node = resultTest.getNode();
            Class nodePoClass = Hibernator.getClass((Object)node);
            if (Hibernator.isPoClassSubclass((Class)nodePoClass, ITestSuitePO.class)) {
                return "ResultTestSuite";
            }
            if (Hibernator.isPoClassSubclass((Class)nodePoClass, IExecTestCasePO.class)) {
                return "ResultTestCase";
            }
            if (Hibernator.isPoClassSubclass((Class)nodePoClass, ICapPO.class)) {
                return "ResultCap";
            }
        }
        throw this.unknownElement(element);
    }

    public RuntimeException unknownElement(Object element) {
        return new RuntimeException(String.valueOf(Messages.UnknownTypeOfElementInTreeOfType) + element.getClass().getName());
    }
}

