/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.search.query;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.FindResponsibleNodesForComponentNameOp;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.search.query.ShowWhereUsedComponentNameQuery;
import org.eclipse.jubula.client.ui.search.result.BasicSearchResult;

public class ShowResponsibleNodeForComponentName
extends ShowWhereUsedComponentNameQuery {
    private IAUTMainPO m_aut;

    public ShowResponsibleNodeForComponentName(IComponentNamePO compName, IAUTMainPO aut) {
        super(compName);
        this.m_aut = aut;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingResponsibleCompNames);
        sb.append(" ");
        sb.append("\"");
        sb.append(this.getCompName().getName());
        sb.append("\"");
        return sb.toString();
    }

    public IStatus run(IProgressMonitor monitor) {
        this.calculateUseOfLogicalName(this.getCompName().getGuid(), monitor);
        return Status.OK_STATUS;
    }

    protected void calculateUseOfLogicalName(String logicalName, IProgressMonitor monitor) {
        HashSet<INodePO> compnameUsingNodes = new HashSet<INodePO>();
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        for (ITestSuitePO ts : currentProject.getTestSuiteCont().getTestSuiteList()) {
            IAUTMainPO aut = ts.getAut();
            if (aut == null || !ObjectUtils.equals((Object)aut.getGuid(), (Object)this.m_aut.getGuid())) continue;
            FindResponsibleNodesForComponentNameOp op = new FindResponsibleNodesForComponentNameOp(logicalName);
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            compnameUsingNodes.addAll(op.getNodes());
        }
        ArrayList<BasicSearchResult.SearchResultElement> reuseLoc = new ArrayList<BasicSearchResult.SearchResultElement>(compnameUsingNodes.size());
        reuseLoc.addAll(this.getSearchResultList(compnameUsingNodes, "org.eclipse.jubula.client.ui.views.CompNamesView"));
        this.setSearchResult(reuseLoc);
        monitor.done();
    }
}

