/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.views.TestSuiteBrowser;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public abstract class CommandHelper {
    private static Log log = LogFactory.getLog(CommandHelper.class);

    private CommandHelper() {
    }

    public static void openEditorForNode(INodePO node, AbstractJBTreeView gdtv) {
        if (node instanceof ISpecTestCasePO || node instanceof IExecTestCasePO || node instanceof IEventExecTestCasePO || node instanceof ICapPO) {
            if (gdtv instanceof TestSuiteBrowser) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenTestsuiteEditor");
            } else {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenTestcaseEditor");
            }
        } else if (node instanceof ITestSuitePO) {
            CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenTestsuiteEditor");
        } else if (node instanceof IRefTestSuitePO || node instanceof ITestJobPO) {
            CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenTestJobEditor");
        } else if (node instanceof ITestDataCubePO) {
            CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenCentralTestDataEditor");
        }
    }

    public static Object executeCommand(String commandID) {
        return CommandHelper.executeCommand(commandID, null);
    }

    public static Object executeCommand(String commandID, IWorkbenchPartSite site) {
        Class<IHandlerService> hsc = IHandlerService.class;
        IHandlerService handlerService = site != null ? (IHandlerService)site.getService(hsc) : (IHandlerService)PlatformUI.getWorkbench().getService(hsc);
        try {
            return handlerService.executeCommand(commandID, null);
        }
        catch (CommandException commandException) {
            log.warn((Object)(String.valueOf(Messages.ErrorOccurredWhileExecutingCommand) + ":" + " " + commandID));
            return null;
        }
    }

    public static void createContributionPushItem(IMenuManager menuManager, String commandId) {
        menuManager.add(CommandHelper.createContributionItem(commandId, null, null, 8));
    }

    public static IContributionItem createContributionItem(String commandId, Map params, String label, int style) {
        CommandContributionItemParameter itemParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, commandId, style);
        itemParameter.label = label;
        if (params != null) {
            if (itemParameter.parameters == null) {
                itemParameter.parameters = new HashMap(params);
            } else {
                itemParameter.parameters.putAll(params);
            }
        }
        return new CommandContributionItem(itemParameter);
    }
}

