/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Hibernator;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBRuntimeException;
import org.eclipse.jubula.tools.messagehandling.Message;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Log log = LogFactory.getLog(Utils.class);
    private static Dialog dlg = null;

    private Utils() {
    }

    public static Locale getDefaultLocale() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project.getDefaultLanguage() != null) {
            return project.getDefaultLanguage();
        }
        return Locale.getDefault();
    }

    public static boolean isLocalhost() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        String serverPort = prefStore.getString("SERVER_SETTINGS_KEY");
        String server = serverPort.split(":")[0];
        return server.equals(Messages.UtilsLocalhost1) || server.equals(Messages.UtilsLocalhost3) || server.startsWith(Messages.UtilsLocalhost2);
    }

    public static boolean openPerspective(String perspectiveID) {
        IWorkbenchWindow activeWindow;
        IWorkbench worbench;
        block11: {
            MessageDialogWithToggle dialog;
            block10: {
                IPreferenceStore preferenceStore;
                block9: {
                    int value;
                    block8: {
                        block7: {
                            worbench = PlatformUI.getWorkbench();
                            activeWindow = worbench.getActiveWorkbenchWindow();
                            try {
                                if (Plugin.getActivePerspective() == null || !Plugin.getActivePerspective().getId().equals(perspectiveID)) break block7;
                                return true;
                            }
                            catch (WorkbenchException e) {
                                StringBuilder msg = new StringBuilder();
                                msg.append(Messages.CannotOpenThePerspective).append(":").append(" ").append(perspectiveID).append("(").append((Object)e).append(")").append(".");
                                log.error((Object)msg.toString());
                                Utils.createMessageDialog(MessageIDs.E_NO_PERSPECTIVE);
                                return false;
                            }
                        }
                        preferenceStore = Plugin.getDefault().getPreferenceStore();
                        value = preferenceStore.getInt("PERSP_CHANGE_KEY");
                        if (value != 0) break block8;
                        worbench.showPerspective(perspectiveID, activeWindow);
                        return true;
                    }
                    if (value != 1) break block9;
                    return true;
                }
                String perspectiveName = "";
                perspectiveName = perspectiveID.equals("org.eclipse.jubula.client.ui.perspectives.SpecificationPerspective") ? Messages.UtilsSpecPerspective : Messages.UtilsExecPerspective;
                dialog = new MessageDialogWithToggle(Plugin.getShell(), Messages.UtilsTitle, null, NLS.bind((String)Messages.UtilsQuestion, (Object[])new Object[]{perspectiveName}), 3, new String[]{Messages.UtilsYes, Messages.UtilsNo}, 0, Messages.UtilsRemember, false){

                    protected void buttonPressed(int buttonId) {
                        super.buttonPressed(buttonId);
                        preferenceStore.setValue("REMEMBER_KEY", this.getToggleState());
                        int val = 2;
                        if (this.getToggleState() && this.getReturnCode() == 257) {
                            val = 1;
                        } else if (this.getToggleState() && this.getReturnCode() == 256) {
                            val = 0;
                        }
                        preferenceStore.setValue("PERSP_CHANGE_KEY", val);
                    }
                };
                dialog.create();
                DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                dialog.open();
                if (dialog.getReturnCode() != 257) break block10;
                return true;
            }
            if (dialog.getReturnCode() != -1) break block11;
            return false;
        }
        worbench.showPerspective(perspectiveID, activeWindow);
        return true;
    }

    public static List<Object> getExpandedTreeItems(TreeViewer tv) {
        Object[] expandedElems = tv.getExpandedElements();
        return new ArrayList<Object>(Arrays.asList(expandedElems));
    }

    public static String getLastDirPath() {
        return Plugin.getDefault().getPreferenceStore().getString("START_BROWSE_PATH_KEY");
    }

    public static void storeLastDirPath(String path) {
        Plugin.getDefault().getPreferenceStore().setValue("START_BROWSE_PATH_KEY", path);
    }

    public static List<String> getAvailableLanguages() {
        Languages langUtil = Languages.getInstance();
        ArrayList<String> list = new ArrayList<String>();
        for (Locale locale : langUtil.getSuppLangList()) {
            list.add(langUtil.getDisplayString(locale));
        }
        return list;
    }

    public static void clearClient() {
        Utils.clearClient(false);
    }

    public static void clearClient(final boolean alsoProjectIndependent) {
        final DataEventDispatcher ded = DataEventDispatcher.getInstance();
        TestExecution.getInstance().stopExecution();
        GeneralStorage gs = GeneralStorage.getInstance();
        if (gs != null && Hibernator.instance() != null) {
            IProjectPO currProj = gs.getProject();
            if (currProj != null) {
                gs.setProject(null);
                ded.fireDataChangedListener((IPersistentObject)currProj, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
            }
            gs.reset();
        }
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                TestExecutionContributor.getInstance().getClientTest().resetToTesting();
                ded.fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.notRunning);
                ded.fireOMStateChanged(DataEventDispatcher.OMState.notRunning);
                Plugin.closeAllOpenedJubulaEditors(alsoProjectIndependent);
                ded.fireTestresultChanged(DataEventDispatcher.TestresultState.Refresh);
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.views.TestResultTreeView");
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.views.TestCaseBrowser");
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.views.TestSuiteBrowser");
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.views.ComponentNameBrowser");
            }
        });
        ded.fireProjectLoadedListener((IProgressMonitor)new NullProgressMonitor());
    }

    private static void setTreeViewerInputNull(String viewID) {
        IViewPart view = Plugin.getView(viewID);
        if (view instanceof ITreeViewerContainer) {
            ((ITreeViewerContainer)view).getTreeViewer().setInput(null);
        }
    }

    private static String[] lineFeed(String[] strArray) {
        ArrayList<String> strList = new ArrayList<String>();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            StringTokenizer tok = new StringTokenizer(str, "\n");
            while (tok.hasMoreElements()) {
                strList.add(tok.nextToken());
            }
            ++n2;
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static Dialog createMessageDialog(JBRuntimeException ex) {
        Integer messageID = ex.getErrorId();
        Message m = MessageIDs.getMessageObject((Integer)messageID);
        if (m != null && m.getSeverity() == 4) {
            log.error((Object)(String.valueOf(Messages.AnErrorHasOccurred) + "."), (Throwable)ex);
        }
        return Utils.createMessageDialog(messageID, null, Utils.getStackTrace(ex.getCausedBy()));
    }

    public static String[] getStackTrace(Throwable throwable) {
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            return ((Object)writer).toString().split("\n");
        }
        return null;
    }

    public static Dialog createMessageDialog(JBException ex) {
        return Utils.createMessageDialog(ex, null, null);
    }

    public static Dialog createMessageDialog(JBException ex, Object[] params, String[] details) {
        Integer messageID = ex.getErrorId();
        Message m = MessageIDs.getMessageObject((Integer)messageID);
        if (m != null && m.getSeverity() == 4) {
            log.error((Object)(String.valueOf(Messages.AnErrorHasOccurred) + "."), (Throwable)ex);
        }
        return Utils.createMessageDialog(messageID, params, details);
    }

    public static Dialog createMessageDialog(final Integer messageID, final Object[] params, final String[] details) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dlg = Utils.createMessageDialog(messageID, params, details, Plugin.getShell());
            }
        });
        return dlg;
    }

    public static Dialog createMessageDialog(Integer messageID) {
        return Utils.createMessageDialog(messageID, null, null);
    }

    public static Dialog createMessageDialog(Integer messageID, Object[] params, String[] details, Shell parent) {
        String title = "";
        String message = "";
        String[] labels = new String[]{Messages.UtilsOK};
        int imageID = 2;
        Message msg = MessageIDs.getMessageObject((Integer)messageID);
        String[] detail = Utils.lineFeed(msg.getDetails());
        if (details != null) {
            detail = Utils.lineFeed(details);
        }
        switch (msg.getSeverity()) {
            case 4: {
                title = Messages.UtilsError;
                message = Messages.UtilsErrorOccurred;
                break;
            }
            case 1: {
                title = Messages.UtilsInfo1;
                message = Messages.UtilsInfo2;
                break;
            }
            case 2: {
                title = Messages.UtilsWarning1;
                message = Messages.UtilsWarning2;
                break;
            }
            case 0: {
                title = Messages.UtilsRequest1;
                message = Messages.UtilsRequest2;
                labels = new String[]{Messages.UtilsYes, Messages.UtilsNo};
                imageID = 3;
                break;
            }
        }
        Status[] status = new Status[detail.length];
        int i = 0;
        while (i < detail.length) {
            status[i] = new Status(msg.getSeverity(), "org.eclipse.jubula.client.ui", 0, detail[i], null);
            ++i;
        }
        if (msg.getSeverity() == 1 || msg.getSeverity() == 0) {
            StringBuilder messageBuilder = new StringBuilder(message);
            messageBuilder.append(msg.getMessage(params));
            messageBuilder.append("\n");
            Status[] statusArray = status;
            int n = status.length;
            int n2 = 0;
            while (n2 < n) {
                Status s = statusArray[n2];
                if (s.getMessage() != Message.NO_DETAILS) {
                    messageBuilder.append("\n");
                    messageBuilder.append(s.getMessage());
                }
                ++n2;
            }
            dlg = new MessageDialog(parent, title, null, messageBuilder.toString(), imageID, labels, 0);
        } else {
            dlg = new ErrorDialog(new Shell(16384), title, message, (IStatus)new MultiStatus("org.eclipse.jubula.client.ui", 0, (IStatus[])status, msg.getMessage(params), null), 7);
        }
        dlg.create();
        DialogUtils.setWidgetNameForModalDialog(dlg);
        dlg.open();
        return dlg;
    }

    public static IEditorPart getEditorByPO(IPersistentObject po) {
        IEditorReference editorRef = Utils.getEditorRefByPO(po);
        if (editorRef != null) {
            return editorRef.getEditor(false);
        }
        return null;
    }

    public static IEditorReference getEditorRefByPO(IPersistentObject po) {
        for (IEditorReference editorRef : Plugin.getAllEditors()) {
            PersistableEditorInput pei = null;
            try {
                pei = (PersistableEditorInput)editorRef.getEditorInput().getAdapter(PersistableEditorInput.class);
            }
            catch (PartInitException partInitException) {}
            if (pei == null || !pei.getNode().equals(po)) continue;
            return editorRef;
        }
        return null;
    }

    public static String getComponentType(IExecTestCasePO exec, String name) {
        return Utils.getComponentType(exec, name, false);
    }

    private static String getComponentType(IExecTestCasePO exec, String name, boolean checkForPropagate) {
        String type = "";
        ICompNamesPairPO compNamesPair = exec.getCompNamesPair(name);
        if (compNamesPair != null) {
            if (checkForPropagate) {
                if (compNamesPair.isPropagated()) {
                    type = Utils.searchCompTypeInTree(exec, name);
                    compNamesPair.setType(type);
                    return type;
                }
            } else {
                return Utils.searchCompTypeInTree(exec, name);
            }
        }
        if (exec.getCompNamesPairs().isEmpty()) {
            return Utils.searchCompTypeInTree(exec, name);
        }
        for (ICompNamesPairPO pair : exec.getCompNamesPairs()) {
            if (pair.getSecondName() == null || !pair.getSecondName().equals(name)) continue;
            if (checkForPropagate) {
                if (!pair.isPropagated()) continue;
                return Utils.getComponentType(exec, pair.getFirstName(), true);
            }
            return Utils.getComponentType(exec, pair.getFirstName(), true);
        }
        return "";
    }

    private static String searchCompTypeInTree(IExecTestCasePO exec, String name) {
        String type = "";
        if (exec.getSpecTestCase() != null) {
            for (Object node : exec.getSpecTestCase().getUnmodifiableNodeList()) {
                if (node instanceof ICapPO) {
                    ICapPO cap = (ICapPO)node;
                    if (!cap.getComponentName().equals(name)) continue;
                    return cap.getComponentType();
                }
                if (node instanceof IExecTestCasePO && !"".equals(type = Utils.getComponentType((IExecTestCasePO)node, name, true))) break;
            }
        }
        return type;
    }

    public static void makeAutConfigCopy(Map<String, String> autConfigOrig, Map<String, String> autConfigCopy) {
        autConfigCopy.clear();
        Set<String> autConfigKeys = autConfigOrig.keySet();
        for (String key : autConfigKeys) {
            String value = autConfigOrig.get(key);
            if (value == null || value.length() <= 0) continue;
            autConfigCopy.put(key, value);
        }
    }
}

