/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ICompNameValidator;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ReusedCompNameValidator;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.editors.IJBEditor;
import org.eclipse.jubula.client.ui.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.widgets.CompNameCellValidator;
import org.eclipse.jubula.client.ui.widgets.CompNamePopupTextCellEditor;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class CompNamesPage
extends Page
implements ISelectionListener {
    private static final String COLUMN_PROPAGATE = "propagate";
    private static final String COLUMN_OLD_NAME = "firstName";
    private static final String COLUMN_NEW_NAME = "secondName";
    private static final String COLUMN_TYPE_NAME = "type";
    private static final int COLUMN_WIDTH = 70;
    private CompNamesBP m_compNamesBP = new CompNamesBP();
    private IExecTestCasePO m_selectedExecNode;
    private IExecTestCasePO m_oldSelectedExecNode;
    private IWorkbenchPart m_selectedExecNodeOwner;
    private IWorkbenchPart m_oldSelectedExecNodeOwner;
    private CheckboxTableViewer m_tableViewer;
    private Control m_control;
    private ICompNamesPairPO m_selectedPair = null;
    private TableSelectionChangedListener m_selectionChangedListener = new TableSelectionChangedListener();
    private CompNamePopupTextCellEditor m_cellEdit;
    private CellModifier m_cellModifier;
    private CellEditorListener m_cellEditorListener = new CellEditorListener();
    private CheckStateListener m_checkStateListener = new CheckStateListener();
    private boolean m_editable;
    private IComponentNameMapper m_compMapper;
    private boolean m_invalidData = false;

    private void searchAndSetComponentType(ICompNamesPairPO pair) {
        IPersistentObject orig;
        if (pair.getType() != null && !"".equals(pair.getType())) {
            return;
        }
        if (this.m_selectedExecNodeOwner instanceof IJBEditor && ((orig = ((IJBEditor)this.m_selectedExecNodeOwner).getEditorHelper().getEditSupport().getOriginal()) instanceof ISpecTestCasePO || orig instanceof ITestSuitePO)) {
            INodePO origNode = (INodePO)orig;
            for (Object node : origNode.getUnmodifiableNodeList()) {
                if (!CompNamesBP.searchCompType((ICompNamesPairPO)pair, node)) continue;
                return;
            }
        }
        if (pair.getType() == null || "".equals(pair.getType())) {
            CompNamesBP.searchCompType((ICompNamesPairPO)pair, (Object)this.m_selectedExecNode);
        }
    }

    private void updateViewAndNotifyModelListeners() {
        this.setActualTCEditorDirty();
        this.m_tableViewer.refresh();
    }

    private void setActualTCEditorDirty() {
        AbstractTestCaseEditor edit = Plugin.getDefault().getActiveTCEditor();
        if (edit != null && edit.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK && !edit.isDirty()) {
            edit.getEditorHelper().setDirty(true);
        }
    }

    private void updatePropagated(ICompNamesPairPO pair, boolean propagated) {
        boolean updated = this.m_compNamesBP.updateCompNamesPair(this.m_selectedExecNode, pair, propagated);
        if (updated) {
            this.updateViewAndNotifyModelListeners();
        }
    }

    private boolean updateSecondName(ICompNamesPairPO pair, String secondName) {
        boolean updateSuccessfull = false;
        if (!this.getInvalidData()) {
            if (this.m_selectedExecNodeOwner instanceof IJBEditor) {
                if (this.m_selectedExecNode != null) {
                    IJBEditor editor = (IJBEditor)this.m_selectedExecNodeOwner;
                    IWritableComponentNameMapper compMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
                    try {
                        boolean updated = this.m_compNamesBP.updateCompNamesPair(this.m_selectedExecNode, pair, secondName, compMapper);
                        if (updated) {
                            updateSuccessfull = updated;
                            this.updateViewAndNotifyModelListeners();
                        }
                    }
                    catch (IncompatibleTypeException e) {
                        this.setInvalidData(true);
                        Utils.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                    }
                    catch (PMAlreadyLockedException pme) {
                        this.setInvalidData(true);
                        PMExceptionHandler.handlePMAlreadyLockedException(pme, new String[]{String.valueOf(Messages.TheComponentName) + " \"" + secondName + "\" " + Messages.IsAlreadyInUseInDifferentEditor, Messages.PleaseSaveTheseEditorsFirst});
                    }
                    catch (PMException pme) {
                        this.setInvalidData(true);
                        PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
                    }
                }
            } else {
                Assert.notReached((String)Messages.m_selectedExecNodeOwnerIsNotAnInstanceOfIGDEditor);
            }
        }
        return updateSuccessfull;
    }

    private void updateTableInput(boolean editable) {
        List input = null;
        if (this.m_selectedExecNode != null) {
            input = this.m_compNamesBP.getAllCompNamesPairs(this.m_selectedExecNode);
            for (ICompNamesPairPO pair : input) {
                this.searchAndSetComponentType(pair);
            }
            IWorkbenchPart activePart = Plugin.getActivePart();
            if (activePart instanceof IJBEditor) {
                this.m_compMapper = ((IJBEditor)activePart).getEditorHelper().getEditSupport().getCompMapper();
            }
            this.m_cellEdit.setValidator(new CompNameCellValidator(this.m_tableViewer, (ICompNameValidator)new ReusedCompNameValidator(this.m_compMapper)));
        }
        this.m_tableViewer.setInput(input);
        this.m_cellModifier.setModifiable(editable);
        this.m_editable = editable;
        TableItem[] tableItemArray = this.m_tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (editable) {
                item.setForeground(Layout.DEFAULT_OS_COLOR);
            } else {
                item.setForeground(Layout.GRAY_COLOR);
            }
            item.setGrayed(!editable);
            ++n2;
        }
        Table table = this.m_tableViewer.getTable();
        if (table.getItemCount() != 0) {
            TableColumn[] columns = table.getColumns();
            int columnCount = columns.length;
            int i = 1;
            while (i < columnCount) {
                TableColumn column = columns[i];
                column.pack();
                if (column.getWidth() < 70) {
                    column.setWidth(70);
                }
                ++i;
            }
            for (ICompNamesPairPO pair : input) {
                this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
            }
            table.getColumn(0).setWidth(38);
            table.getColumn(0).setResizable(false);
        }
    }

    private void setParentLayout(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((org.eclipse.swt.widgets.Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        parent.setLayoutData((Object)layoutData);
    }

    public void setFocus() {
        this.m_tableViewer.getTable().setFocus();
    }

    public void dispose() {
        this.m_cellEdit.removeListener(this.m_cellEditorListener);
        this.m_tableViewer.removeCheckStateListener((ICheckStateListener)this.m_checkStateListener);
        this.m_tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
        this.m_tableViewer = null;
        this.m_selectedExecNode = null;
        this.m_selectedExecNodeOwner = null;
        super.dispose();
    }

    public void handleEditorSaved(IWorkbenchPart part, ISelection selection) {
        this.m_oldSelectedExecNode = null;
        this.selectionChanged(part, selection);
    }

    public void createControl(Composite parent) {
        Composite topLevelComposite = new Composite(parent, 0);
        this.setParentLayout(topLevelComposite);
        this.m_control = topLevelComposite;
        this.setParentLayout(topLevelComposite);
        Table table = new Table(topLevelComposite, 67616);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        tc1.setImage(IconConstants.PROPAGATE_IMAGE);
        TableColumn tc2 = new TableColumn(table, 16384);
        tc2.setText(Messages.CompNamesViewOldNameColumn);
        TableColumn tc3 = new TableColumn(table, 16384);
        tc3.setText(Messages.CompNamesViewNewNameColumn);
        TableColumn tc4 = new TableColumn(table, 16384);
        tc4.setText(Messages.CompNamesViewTypeColumn);
        CompNamesViewContentProvider provider = new CompNamesViewContentProvider();
        this.m_tableViewer = new CheckboxTableViewer(table);
        this.m_tableViewer.setContentProvider((IContentProvider)provider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.m_tableViewer.setColumnProperties(new String[]{COLUMN_PROPAGATE, COLUMN_OLD_NAME, COLUMN_NEW_NAME, COLUMN_TYPE_NAME});
        this.m_compMapper = Plugin.getActiveCompMapper();
        this.m_cellEdit = new CompNamePopupTextCellEditor(this.m_compMapper, (Composite)table);
        this.setInvalidData(false);
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[2] = this.m_cellEdit;
        this.m_tableViewer.setCellEditors(cellEditorArray);
        this.m_cellEdit.addListener(this.m_cellEditorListener);
        this.m_cellModifier = new CellModifier();
        this.m_tableViewer.setCellModifier((ICellModifier)this.m_cellModifier);
        this.m_tableViewer.addCheckStateListener((ICheckStateListener)this.m_checkStateListener);
        this.m_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
        Plugin.getHelpSystem().setHelp((Control)topLevelComposite, "org.eclipse.jubula.client.ua.help.compNameViewContextId");
    }

    public Control getControl() {
        return this.m_control;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        boolean isEditor = part instanceof AbstractTestCaseEditor;
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.getFirstElement() instanceof IExecTestCasePO) {
            this.m_selectedExecNode = (IExecTestCasePO)sel.getFirstElement();
            this.m_selectedExecNodeOwner = part;
        } else {
            this.m_selectedExecNode = null;
        }
        if (this.m_selectedExecNode == null || this.m_selectedExecNode != null && !this.m_selectedExecNode.equals((Object)this.m_oldSelectedExecNode) || !this.m_selectedExecNodeOwner.equals(this.m_oldSelectedExecNodeOwner)) {
            AbstractTestCaseEditor editor;
            if (part instanceof IJBEditor) {
                this.m_cellEdit.setComponentNameMapper((IComponentNameMapper)((IJBEditor)part).getEditorHelper().getEditSupport().getCompMapper());
            }
            this.updateTableInput(isEditor);
            if (isEditor && (editor = (AbstractTestCaseEditor)part).getEditorInput() instanceof ITestSuitePO) {
                this.m_cellModifier.setModifiable(false);
            }
        }
        this.m_oldSelectedExecNode = this.m_selectedExecNode;
        this.m_oldSelectedExecNodeOwner = this.m_selectedExecNodeOwner;
    }

    private void setInvalidData(boolean invalidData) {
        this.m_invalidData = invalidData;
    }

    private boolean getInvalidData() {
        return this.m_invalidData;
    }

    private final class CellEditorListener
    implements ICellEditorListener {
        private CellEditorListener() {
        }

        public void applyEditorValue() {
            String newName;
            Object value = CompNamesPage.this.m_cellEdit.getValue();
            String string = newName = value != null ? value.toString() : "";
            if (CompNamesPage.this.m_cellEdit.isDirty() && CompNamesPage.this.updateSecondName(CompNamesPage.this.m_selectedPair, newName)) {
                CompNamesPage.this.setActualTCEditorDirty();
            }
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }
    }

    public class CellModifier
    implements ICellModifier {
        private boolean m_modifiable = true;

        private ICompNamesPairPO getPair(Object element) {
            return (ICompNamesPairPO)(element instanceof Item ? ((Item)element).getData() : element);
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof ICompNamesPairPO) {
                ICompNamesPairPO compNamesPair = (ICompNamesPairPO)element;
                return CompNamesPage.COLUMN_NEW_NAME.equals(property) && this.isModifiable() && compNamesPair.getType().length() != 0;
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (CompNamesPage.this.m_compMapper != null) {
                return CompNamesPage.this.m_compMapper.getCompNameCache().getName(this.getPair(element).getSecondName());
            }
            return ComponentNamesBP.getInstance().getName(this.getPair(element).getSecondName());
        }

        public void modify(Object element, String property, Object value) {
            if (this.getValue(element, property).equals(value) || value != null && ((String)value).trim().length() == 0) {
                return;
            }
            CompNamesPage.this.updateSecondName(this.getPair(element), (String)value);
        }

        public void setModifiable(boolean modifiable) {
            this.m_modifiable = modifiable;
        }

        public boolean isModifiable() {
            return this.m_modifiable;
        }
    }

    private final class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            ICompNamesPairPO pair = (ICompNamesPairPO)event.getElement();
            CompNamesPage.this.m_cellModifier.setModifiable(CompNamesPage.this.m_editable && !"".equals(pair.getType()));
            if (!CompNamesPage.this.m_cellModifier.isModifiable() || CompNamesPage.this.m_selectedExecNodeOwner instanceof TestSuiteEditor) {
                CompNamesPage.this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
                return;
            }
            CompNamesPage.this.updatePropagated(pair, event.getChecked());
        }
    }

    private class CompNamesViewContentProvider
    implements IStructuredContentProvider {
        private CompNamesViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            CompNamesPage.this.searchAndSetComponentType((ICompNamesPairPO)element);
            String type = ((ICompNamesPairPO)element).getType();
            switch (columnIndex) {
                case 0: {
                    if ("".equals(type)) {
                        CompNamesPage.this.m_tableViewer.getTable().getColumn(0).pack();
                        return IconConstants.WARNING_IMAGE;
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICompNamesPairPO pair = (ICompNamesPairPO)element;
            Table table = CompNamesPage.this.m_tableViewer.getTable();
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    if (CompNamesPage.this.m_compMapper != null) {
                        return CompNamesPage.this.m_compMapper.getCompNameCache().getName(pair.getFirstName());
                    }
                    return ComponentNamesBP.getInstance().getName(pair.getFirstName());
                }
                case 2: {
                    if (CompNamesPage.this.m_compMapper != null) {
                        return CompNamesPage.this.m_compMapper.getCompNameCache().getName(pair.getSecondName());
                    }
                    return ComponentNamesBP.getInstance().getName(pair.getSecondName());
                }
                case 3: {
                    CompNamesPage.this.searchAndSetComponentType(pair);
                    String type = pair.getType();
                    int i = 0;
                    while (i < table.getItems().length) {
                        if (table.getItems()[i].getData() != null && table.getItems()[i].getData().equals(pair)) {
                            TableItem item;
                            if ("".equals(type)) {
                                type = "CompNamesView.errorText";
                                item = table.getItem(i);
                                item.setForeground(3, Layout.ERROR_COLOR);
                                item.setFont(3, Layout.ITALIC_TAHOMA);
                                if (CompNamesPage.this.m_selectedExecNodeOwner instanceof AbstractTestCaseEditor) {
                                    CompNamesPage.this.m_tableViewer.setGrayed((Object)pair, false);
                                    CompNamesPage.this.m_tableViewer.setChecked((Object)pair, false);
                                }
                            } else {
                                item = table.getItem(i);
                                item.setForeground(3, Layout.GRAY_COLOR);
                                item.setFont(3, Layout.NORMAL_TAHOMA);
                                if (CompNamesPage.this.m_selectedExecNodeOwner instanceof AbstractTestCaseEditor) {
                                    item.setForeground(3, Layout.DEFAULT_OS_COLOR);
                                    CompNamesPage.this.m_tableViewer.setGrayed((Object)pair, true);
                                    CompNamesPage.this.m_tableViewer.setChecked((Object)pair, true);
                                }
                            }
                        }
                        ++i;
                    }
                    return CompSystemI18n.getString((String)type);
                }
            }
            return null;
        }
    }

    private class TableSelectionChangedListener
    implements ISelectionChangedListener {
        private TableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof ICompNamesPairPO && CompNamesPage.this.m_selectedExecNodeOwner instanceof AbstractTestCaseEditor) {
                ICompNamesPairPO pair = (ICompNamesPairPO)o;
                CompNamesPage.this.m_selectedPair = pair;
                CompNamesPage.this.m_cellModifier.setModifiable(CompNamesPage.this.m_editable && !"".equals(pair.getType()));
                if (!CompNamesPage.this.m_cellModifier.isModifiable()) {
                    return;
                }
                String filter = pair.getType();
                if (filter == null || "".equals(filter)) {
                    IExecTestCasePO execNode = CompNamesPage.this.m_selectedExecNode;
                    IPersistentObject po = ((AbstractTestCaseEditor)CompNamesPage.this.m_selectedExecNodeOwner).getEditorHelper().getEditSupport().getOriginal();
                    if (po instanceof ISpecTestCasePO) {
                        for (Object node : ((ISpecTestCasePO)po).getUnmodifiableNodeList()) {
                            if (!node.equals(CompNamesPage.this.m_selectedExecNode)) continue;
                            execNode = (IExecTestCasePO)node;
                            break;
                        }
                    }
                    filter = Utils.getComponentType(execNode, pair.getFirstName());
                }
                CompNamesPage.this.m_cellEdit.setFilter(filter);
                CompNamesPage.this.setInvalidData(false);
            } else {
                CompNamesPage.this.m_selectedPair = null;
            }
        }
    }
}

