/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractToolTipListener
implements Listener {
    private Control m_toolTipOwner;
    private JBText m_toolTipContent;
    private Shell m_tip;
    private Listener m_labelListener = new LabelListener();

    public AbstractToolTipListener(Control toolTipOwner) {
        this.m_toolTipOwner = toolTipOwner;
        this.m_toolTipOwner.addListener(12, (Listener)this);
        this.m_toolTipOwner.addListener(1, (Listener)this);
        this.m_toolTipOwner.addListener(5, (Listener)this);
        this.m_toolTipOwner.addListener(32, (Listener)this);
        this.m_toolTipContent = new JBText((Composite)this.m_toolTipOwner.getShell(), 66);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: 
            case 5: 
            case 12: {
                if (this.m_tip == null) break;
                this.m_tip.dispose();
                this.m_tip = null;
                this.m_toolTipContent = null;
                break;
            }
            case 32: {
                Point point = new Point(event.x, event.y);
                Item item = this.getItem(this.m_toolTipOwner, point);
                if (item == null) break;
                if (this.m_tip != null && !this.m_tip.isDisposed()) {
                    this.m_tip.dispose();
                }
                if (!this.checkCreateToolTip(item, point, this.getToolTipParent())) {
                    return;
                }
                this.m_tip = new Shell(this.m_toolTipOwner.getShell(), 16388);
                this.m_tip.setLayout((org.eclipse.swt.widgets.Layout)new FillLayout());
                this.m_toolTipContent = new JBText((Composite)this.m_tip, 74);
                this.m_toolTipContent.setForeground(this.m_toolTipOwner.getDisplay().getSystemColor(28));
                this.m_toolTipContent.setBackground(this.m_toolTipOwner.getDisplay().getSystemColor(29));
                this.m_toolTipContent.setData("_TABLEITEM", item);
                this.m_toolTipContent.setText(this.getTextOfItem(item, this.getColumnForToolTip()));
                this.m_toolTipContent.addListener(7, this.m_labelListener);
                this.m_toolTipContent.addListener(3, this.m_labelListener);
                Rectangle itemBounds = this.getBoundsOfItem(item, this.getColumnForToolTip());
                int height = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)this.m_toolTipContent), (int)(this.m_toolTipContent.getLineCount() + 2));
                Point pt = this.m_toolTipOwner.toDisplay(itemBounds.x, itemBounds.y);
                this.m_tip.setBounds(pt.x, pt.y, itemBounds.width, height);
                this.m_tip.setVisible(true);
            }
        }
    }

    protected abstract Composite getToolTipParent();

    protected abstract int getColumnForToolTip();

    public static TreeItem[] getItemsOfTree(TreeItem[] items, TreeItem[] allItems) {
        TreeItem[] concItems = new TreeItem[items.length + allItems.length];
        System.arraycopy(items, 0, concItems, 0, items.length);
        System.arraycopy(allItems, 0, concItems, items.length, allItems.length);
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            concItems = AbstractToolTipListener.getItemsOfTree(item.getItems(), concItems);
            ++n2;
        }
        return concItems;
    }

    protected boolean checkCreateToolTip(Item item, Point point, Composite parent) {
        TreeItem[] items;
        Tree tree = (Tree)this.getToolTipOwner();
        TreeItem[] treeItemArray = items = AbstractToolTipListener.getItemsOfTree(tree.getItems(), new TreeItem[0]);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            int i = 0;
            while (i < tree.getColumnCount()) {
                Rectangle rect = treeitem.getBounds(i);
                if (rect.contains(point) && rect.equals((Object)this.getBoundsOfItem(item, this.getColumnForToolTip()))) {
                    JBText t = new JBText(parent, 0);
                    t.setVisible(false);
                    t.setText(this.getTextOfItem(item, this.getColumnForToolTip()));
                    GC gc = new GC((Drawable)t);
                    int textPixels = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)t.getText())).append((String)"  ").toString()).x;
                    gc.dispose();
                    t.dispose();
                    int textFieldPixels = this.getBoundsOfItem((Item)item, (int)this.getColumnForToolTip()).width;
                    return textPixels > textFieldPixels;
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    protected Item getItem(Control control, Point point) {
        if (control instanceof Tree) {
            return ((Tree)control).getItem(point);
        }
        if (control instanceof Table) {
            ((Table)control).getItem(point);
        }
        return null;
    }

    protected Rectangle getBoundsOfItem(Item item, int index) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(index);
        }
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds(index);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    protected String getTextOfItem(Item item, int index) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getText(index);
        }
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getText(index);
        }
        return "";
    }

    protected Control getToolTipOwner() {
        return this.m_toolTipOwner;
    }

    private class LabelListener
    implements Listener {
        private LabelListener() {
        }

        public void handleEvent(Event event) {
            Tree tree = (Tree)AbstractToolTipListener.this.m_toolTipOwner;
            JBText label = (JBText)event.widget;
            Shell shell = label.getShell();
            switch (event.type) {
                case 3: {
                    Event e = new Event();
                    e.item = (Item)label.getData("_TABLEITEM");
                    tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                    tree.notifyListeners(13, e);
                }
                case 7: {
                    shell.dispose();
                    break;
                }
            }
        }
    }
}

