/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.io.File;
import org.eclipse.jubula.client.ui.widgets.CheckedText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CheckedDirnameText
extends CheckedText {
    public CheckedDirnameText(Composite parent, int style) {
        super(parent, style, new DirnameValidator());
    }

    private static class DirnameValidator
    implements CheckedText.IValidator {
        private DirnameValidator() {
        }

        public CheckedText.ValidationState validateInput(VerifyEvent e) {
            Text txt = (Text)e.widget;
            String oldValue = txt.getText();
            StringBuilder workValue = new StringBuilder(oldValue);
            workValue.replace(e.start, e.end, e.text);
            String newValue = workValue.toString();
            if (!txt.isEnabled()) {
                return CheckedText.ValidationState.EmptyAccept;
            }
            File f = new File(newValue);
            if (!f.isAbsolute()) {
                return CheckedText.ValidationState.MightMatchAccept;
            }
            if (f.isDirectory() && f.canRead()) {
                return CheckedText.ValidationState.OK;
            }
            return CheckedText.ValidationState.MightMatchAccept;
        }
    }
}

