/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;

public class ParamProposalProvider
implements IContentProposalProvider {
    private static final String PARAMETER_PREFIX = "=";
    private String[] m_valueSet;
    private INodePO m_node;
    private IParamDescriptionPO m_paramDesc;

    public ParamProposalProvider(String[] valueSet, INodePO node, IParamDescriptionPO paramDesc) {
        this.m_valueSet = valueSet;
        this.m_node = node;
        this.m_paramDesc = paramDesc;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (position != contents.length()) {
            return new IContentProposal[0];
        }
        ArrayList<ParamProposal> proposals = new ArrayList<ParamProposal>(20);
        if (this.m_valueSet != null) {
            StringBuilder sb = new StringBuilder(contents);
            sb.delete(position, sb.length());
            sb.delete(0, sb.lastIndexOf(" ") + 1);
            String[] stringArray = this.m_valueSet;
            int n = this.m_valueSet.length;
            int n2 = 0;
            while (n2 < n) {
                Object predefValue = stringArray[n2];
                if (((String)predefValue).startsWith(sb.toString())) {
                    proposals.add(new ParamProposal(((String)predefValue).substring(sb.length()), (String)predefValue));
                } else if (((String)predefValue).startsWith(contents)) {
                    proposals.add(new ParamProposal(((String)predefValue).substring(contents.length()), (String)predefValue));
                }
                ++n2;
            }
        }
        INodePO node = this.m_node;
        while (node != null && !(node instanceof ISpecTestCasePO)) {
            node = node.getParentNode();
        }
        ISpecTestCasePO paramNode = (ISpecTestCasePO)node;
        if (!(this.m_node instanceof ISpecTestCasePO)) {
            if (this.m_paramDesc != null && paramNode != null && !paramNode.isInterfaceLocked().booleanValue() && !paramNode.getParamNames().contains(this.m_paramDesc.getName())) {
                String p = PARAMETER_PREFIX + this.m_paramDesc.getName();
                p = StringUtils.replaceChars((String)p, (char)' ', (char)'_');
                p = StringUtils.replaceChars((String)p, (char)'-', (char)'_');
                if ((p = p.toUpperCase()).startsWith(contents)) {
                    proposals.add(new ParamProposal(p.substring(contents.length()), p));
                }
            }
            if (paramNode != null) {
                List params = paramNode.getParameterList();
                for (IParamDescriptionPO param : params) {
                    String p;
                    if (!param.getType().equals(this.m_paramDesc.getType()) || !(p = PARAMETER_PREFIX + param.getName()).startsWith(contents)) continue;
                    proposals.add(new ParamProposal(p.substring(contents.length()), p));
                }
            }
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public static class ParamProposal
    implements IContentProposal {
        private String m_displayValue;
        private String m_content;

        public ParamProposal(String content) {
            this(content, null);
        }

        public ParamProposal(String content, String displayValue) {
            this.m_content = content;
            this.m_displayValue = displayValue;
        }

        public String getContent() {
            return this.m_content;
        }

        public int getCursorPosition() {
            return this.m_content.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.m_displayValue;
        }
    }
}

