/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.TokenError;
import org.eclipse.jubula.client.ui.widgets.CheckedText;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ParamValueValidator
implements CheckedText.IValidator {
    private IParameterInterfacePO m_node;
    private IParamDescriptionPO m_desc;
    private boolean m_emptyAllowed;

    public ParamValueValidator(IParameterInterfacePO node, IParamDescriptionPO desc, boolean emptyAllowed) {
        this.m_node = node;
        this.m_desc = desc;
        this.m_emptyAllowed = emptyAllowed;
    }

    public CheckedText.ValidationState validateInput(VerifyEvent e) {
        String newValue = this.getNewValue(e);
        CheckedText.ValidationState val = CheckedText.ValidationState.OK;
        if (StringUtils.isEmpty((String)newValue)) {
            val = this.m_emptyAllowed ? CheckedText.ValidationState.EmptyAccept : CheckedText.ValidationState.MightMatchAccept;
        }
        return val;
    }

    String getNewValue(VerifyEvent e) {
        Text txt = (Text)e.widget;
        String oldValue = txt.getText();
        StringBuilder workValue = new StringBuilder(oldValue);
        workValue.replace(e.start, e.end, e.text);
        String newValue = workValue.toString();
        return newValue;
    }

    public static CheckedText.ValidationState setState(Control control, ParamValueConverter conv) {
        CheckedText.ValidationState val = CheckedText.ValidationState.OK;
        List errors = conv.getErrors();
        if (errors.isEmpty()) {
            val = CheckedText.ValidationState.OK;
        } else {
            for (TokenError error : errors) {
                if (error.getValidationState() == ParamValueConverter.ConvValidationState.invalid) {
                    val = CheckedText.ValidationState.DontMatchAccept;
                    ParamValueValidator.setTooltip(error, control);
                    continue;
                }
                if (error.getValidationState() != ParamValueConverter.ConvValidationState.undecided) continue;
                val = CheckedText.ValidationState.MightMatchAccept;
            }
        }
        control.setData("validationState", (Object)val);
        return val;
    }

    public static void setTooltip(TokenError error, Control control) {
        if (error.getI18NErrorKey() != null) {
            String tooltip = "";
            tooltip = error.getI18NErrorKey().equals(MessageIDs.E_SYNTAX_ERROR) ? MessageIDs.getMessageObject((Integer)error.getI18NErrorKey()).getMessage(new Object[]{error.getInput()}) : MessageIDs.getMessageObject((Integer)error.getI18NErrorKey()).getMessage(new Object[0]);
            control.setToolTipText(tooltip);
        }
    }

    IParamDescriptionPO getDesc() {
        return this.m_desc;
    }

    boolean isEmptyAllowed() {
        return this.m_emptyAllowed;
    }

    IParameterInterfacePO getNode() {
        return this.m_node;
    }
}

