/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.wizards.pages;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.client.ui.widgets.AutConfigComponent;
import org.eclipse.jubula.client.ui.wizards.ProjectWizard;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.UnexpectedGenericTypeException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutConfigSettingWizardPage
extends WizardPage
implements DataEventDispatcher.IDialogStatusListener {
    private static Log log = LogFactory.getLog(AutConfigSettingWizardPage.class);
    private IAUTConfigPO m_autConfig;
    private Composite m_composite;
    private IValidator m_autIdValidator;

    public AutConfigSettingWizardPage(String pageName, IAUTConfigPO autConfig, IValidator autIdValidator) {
        super(pageName);
        this.setPageComplete(false);
        this.m_autConfig = autConfig;
        this.m_autIdValidator = autIdValidator;
    }

    public void createControl(Composite parent) {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().addListener((IGenericListener)this);
        ScrolledComposite scroll = new ScrolledComposite(parent, 768);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
        this.m_composite = new Composite(parent, 0);
        scroll.setContent((Control)this.m_composite);
        scroll.setMinSize(this.m_composite.computeSize(-1, -1));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        this.setControl((Control)scroll);
    }

    private void createAutConfigComposite() {
        try {
            ScrolledComposite scroll = (ScrolledComposite)this.getControl();
            this.m_composite = ToolkitSupportBP.getAutConfigComposite((String)this.getWizard().getAutMain().getToolkit(), (Composite)scroll, (int)512, (Map)this.m_autConfig.getConfigMap(), (String)this.getWizard().getAutMain().getName());
            Control oldComposite = scroll.getContent();
            scroll.setContent((Control)this.m_composite);
            if (this.m_composite instanceof AutConfigComponent) {
                ((AutConfigComponent)this.m_composite).setAutIdValidator(this.m_autIdValidator);
            }
            if (oldComposite != null && !oldComposite.isDisposed()) {
                oldComposite.dispose();
            }
            this.setPageComplete(false);
        }
        catch (ToolkitPluginException e) {
            log.error((Object)(String.valueOf(Messages.NoAUTConfigPageForToolkit) + ":" + " " + String.valueOf(this.getWizard().getAutMain().getToolkit())), (Throwable)e);
            Utils.createMessageDialog(MessageIDs.E_NO_AUTCONFIG_DIALOG);
        }
    }

    public ProjectWizard getWizard() {
        return (ProjectWizard)super.getWizard();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.createAutConfigComposite();
        }
        super.setVisible(visible);
    }

    public void dispose() {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().removeListener((IGenericListener)this);
        super.dispose();
    }

    public void eventOccured(List<? extends Object> list) {
        DialogStatusParameter param = (DialogStatusParameter)list.get(0);
        this.setMessage(param.getMessage(), param.getStatusType());
        this.setPageComplete(param.getButtonState());
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
    }

    public void checkGenericListElementType(List<? extends Object> params) throws UnexpectedGenericTypeException {
        Validate.noNullElements(params);
        Class<DialogStatusParameter> type = null;
        int index = 0;
        if (!(params.get(0) instanceof DialogStatusParameter)) {
            type = DialogStatusParameter.class;
        }
        if (type != null) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.GenericType).append(" ").append(type).append(" ").append(Messages.WasExpectedBut).append(" ").append(params.get(index).getClass()).append(" ").append(Messages.WasFound).append(".");
            throw new UnexpectedGenericTypeException(msg.toString(), MessageIDs.E_UNEXPECTED_EXCEPTION);
        }
    }
}

