/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.communication.connection.BroadcastException;
import org.eclipse.jubula.communication.connection.BroadcastInitException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class BroadcastListener
extends Thread {
    private int m_port;
    private MulticastSocket m_socket;
    private InetAddress m_network;
    private boolean m_done = false;
    private List m_broadcastListener;

    public BroadcastListener(String network, int port) throws BroadcastInitException {
        try {
            this.m_port = port;
            this.m_socket = new MulticastSocket(this.m_port);
            this.m_network = InetAddress.getByName(network);
            this.m_socket.joinGroup(this.m_network);
            this.m_broadcastListener = new ArrayList(10);
        }
        catch (SocketException e) {
            throw new BroadcastInitException("Can't open socket", e, MessageIDs.E_AUT_CONNECTION_INIT);
        }
        catch (UnknownHostException e) {
            throw new BroadcastInitException("Host network " + network + " unknown", e, MessageIDs.E_AUT_CONNECTION_INIT);
        }
        catch (IOException e) {
            throw new BroadcastInitException("Host network " + network + " can't be joined", e, MessageIDs.E_AUT_CONNECTION_INIT);
        }
    }

    private DatagramPacket readData() throws BroadcastException {
        try {
            byte[] buffer = new byte[65000];
            DatagramPacket received = new DatagramPacket(buffer, buffer.length);
            this.m_socket.receive(received);
            return received;
        }
        catch (IOException e) {
            throw new BroadcastException("receive failed", e, MessageIDs.E_GENERAL_CONNECTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws BroadcastException {
        block5: {
            try {
                this.m_done = true;
                if (this.m_socket == null) break block5;
                MulticastSocket multicastSocket = this.m_socket;
                synchronized (multicastSocket) {
                    this.m_socket.leaveGroup(this.m_network);
                    this.m_socket.close();
                    this.m_network = null;
                    this.m_broadcastListener.clear();
                    this.m_broadcastListener = null;
                }
                this.m_socket = null;
            }
            catch (IOException e) {
                throw new BroadcastException("dispose failed", e, MessageIDs.E_GENERAL_CONNECTION);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void run() {
        while (!this.m_done) {
            try {
                DatagramPacket dg = this.readData();
                this.fireBroadcastListener(dg);
            }
            catch (BroadcastException broadcastException) {
                try {
                    this.dispose();
                }
                catch (BroadcastException broadcastException2) {}
            }
        }
    }

    public void addBroadcastListener(IBroadcastListener l) {
        this.m_broadcastListener.add(l);
    }

    public void removeBroadcastListener(IBroadcastListener l) {
        this.m_broadcastListener.remove(l);
    }

    private void fireBroadcastListener(DatagramPacket data) {
        Iterator it = this.m_broadcastListener.iterator();
        while (it.hasNext()) {
            IBroadcastListener l = (IBroadcastListener)it.next();
            try {
                l.dataArrived(data);
            }
            catch (Throwable throwable) {}
        }
    }

    public static interface IBroadcastListener {
        public void dataArrived(DatagramPacket var1);
    }
}

