/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.communication.connection.ConnectionState;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class GDSocket
extends Socket {
    private static Log log;
    private boolean m_connectionEstablished = false;
    private int m_state = -1;
    private BufferedReader m_inputStreamReader;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.communication.connection.GDSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public GDSocket(InetAddress address, int port, long waitForServer) throws IOException, JBVersionException {
        super(address, port);
        this.setSoLinger(true, 10);
        this.respondToTypeRequest(waitForServer);
        this.waitForServerState(waitForServer);
    }

    private void respondToTypeRequest(long waitForServer) throws JBVersionException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("waiting for server's 'client type request' with timeout: " + String.valueOf(waitForServer)));
            }
            InputStream inputStream = this.getInputStream();
            PrintStream outputStream = new PrintStream(this.getOutputStream());
            ConnectionState.respondToTypeRequest(waitForServer, this.getInputStreamReader(), inputStream, outputStream, "ClientType.Exclusive");
        }
        catch (JBVersionException gdve) {
            this.handleState(false);
            throw gdve;
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            this.handleState(false);
        }
    }

    public synchronized boolean isConnectionEstablished() {
        return this.m_connectionEstablished;
    }

    public synchronized int getState() {
        return this.m_state;
    }

    private void waitForServerState(long waitForServer) throws JBVersionException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("waiting for server ok:" + String.valueOf(waitForServer)));
            }
            long waitTime = 0L;
            boolean success = false;
            InputStream inputStream = this.getInputStream();
            BufferedReader inputReader = this.getInputStreamReader();
            while (!success && waitTime <= waitForServer) {
                if (inputStream.available() > 0) {
                    String line = inputReader.readLine();
                    int state = ConnectionState.parseState(line);
                    success = true;
                    this.setState(state);
                    switch (state) {
                        case 0: {
                            this.handleState(true);
                            break;
                        }
                        case 1: {
                            this.handleState(false);
                            break;
                        }
                        case 2: {
                            this.handleState(false);
                            throw new JBVersionException("Version error between Client and AUT Agent!", MessageIDs.E_VERSION_ERROR);
                        }
                        default: {
                            log.error((Object)("unknown state received from server: " + line));
                            this.handleState(false);
                            break;
                        }
                    }
                    continue;
                }
                TimeUtil.delay((long)500L);
                waitTime += 500L;
            }
            if (!success) {
                log.debug((Object)"no response from server");
                this.setConnectionEstablished(false);
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            this.handleState(false);
        }
    }

    private void handleState(boolean state) {
        block3: {
            this.setConnectionEstablished(state);
            if (!state) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"IOException raised during closing an unconnected socket", (Throwable)ioe);
                }
            }
        }
    }

    private synchronized void setConnectionEstablished(boolean connected) {
        this.m_connectionEstablished = connected;
    }

    private synchronized void setState(int state) {
        this.m_state = state;
    }

    public BufferedReader getInputStreamReader() throws UnsupportedEncodingException, IOException {
        if (this.m_inputStreamReader == null) {
            this.m_inputStreamReader = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF8"));
        }
        return this.m_inputStreamReader;
    }
}

