/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.common.businessprocess;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jubula.toolkit.common.IToolKitProvider;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.i18n.Messages;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolkitSupportBP {
    private static Log log = LogFactory.getLog(ToolkitSupportBP.class);
    private static Map<ToolkitPluginDescriptor, IToolKitProvider> toolkitProvider = new HashMap<ToolkitPluginDescriptor, IToolKitProvider>();

    private ToolkitSupportBP() {
    }

    public static Composite getAutConfigComposite(String toolkit, Composite parent, int style, Map<String, String> autConfig, String autName) throws ToolkitPluginException {
        IToolKitProvider provider = ToolkitSupportBP.getToolkitProvider(toolkit);
        Composite autConf = provider.getAutConfigDialog(parent, style, autConfig, autName);
        String toolkitName = toolkit;
        while (autConf == null) {
            provider = ToolkitSupportBP.getSuperToolkitProvider(toolkitName);
            toolkitName = ToolkitSupportBP.getToolkitDescriptor(toolkitName).getName();
            if (provider == null) break;
            autConf = provider.getAutConfigDialog(parent, style, autConfig, autName);
        }
        if (autConf == null) {
            ToolkitSupportBP.throwToolkitPluginException(String.valueOf(Messages.NoAutConfigFound) + ":" + " " + String.valueOf(toolkit), null);
        }
        return autConf;
    }

    public static String getToolkitLevel(String toolkitName) throws ToolkitPluginException {
        ToolkitPluginDescriptor descr = ToolkitSupportBP.getToolkitDescriptor(toolkitName);
        return descr.getLevel();
    }

    private static IToolKitProvider getToolkitProvider(String name) throws ToolkitPluginException {
        if (name == null) {
            String msg = String.valueOf(Messages.ToolkitNameIsNull) + "!";
            log.error((Object)msg);
            ToolkitSupportBP.throwToolkitPluginException(msg, null);
        }
        ToolkitPluginDescriptor descr = ToolkitSupportBP.getToolkitDescriptor(name);
        return toolkitProvider.get(descr);
    }

    private static IToolKitProvider getSuperToolkitProvider(String name) throws ToolkitPluginException {
        if (name == null) {
            String msg = String.valueOf(Messages.ToolkitNameIsNull) + "!";
            log.error((Object)msg);
            ToolkitSupportBP.throwToolkitPluginException(msg, null);
        }
        ToolkitPluginDescriptor descr = ToolkitSupportBP.getToolkitDescriptor(name);
        String superId = descr.getIncludes();
        IToolKitProvider superToolkitProv = ToolkitSupportBP.getToolkitProvider(superId);
        return toolkitProvider.get(superToolkitProv);
    }

    private static ToolkitPluginDescriptor getToolkitDescriptor(String toolkitId) throws ToolkitPluginException {
        String msg;
        if (toolkitId == null) {
            msg = String.valueOf(Messages.ToolkitNameIsNull) + "!";
            log.error((Object)msg);
            ToolkitSupportBP.throwToolkitPluginException(msg, null);
        }
        for (ToolkitPluginDescriptor descr : toolkitProvider.keySet()) {
            if (!toolkitId.equals(descr.getToolkitID())) continue;
            return descr;
        }
        msg = String.valueOf(Messages.NoToolkitPluginDescriptorFound) + ":" + " " + String.valueOf(toolkitId);
        log.error((Object)msg);
        ToolkitSupportBP.throwToolkitPluginException(msg, null);
        return null;
    }

    public static void addToolkitProvider(ToolkitPluginDescriptor descr, IToolKitProvider provider) {
        toolkitProvider.put(descr, provider);
    }

    private static void throwToolkitPluginException(String message, Throwable cause) throws ToolkitPluginException {
        if (cause == null) {
            throw new ToolkitPluginException(message);
        }
        throw new ToolkitPluginException(message, cause);
    }
}

