/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.common.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.i18n.Messages;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolkitUtils {
    private static final Log LOG = LogFactory.getLog(ToolkitUtils.class);
    private static Map<String, Integer> abstractness = new HashMap<String, Integer>();

    static {
        abstractness.put("abstract", 0);
        abstractness.put("concrete", 1);
        abstractness.put("toolkit", 2);
    }

    private ToolkitUtils() {
    }

    public static URL getURL(Plugin plugin, String pluginRelPath) {
        URL unresolvedUrl = plugin.getBundle().getEntry(pluginRelPath);
        URL fileURL = null;
        try {
            fileURL = FileLocator.toFileURL((URL)unresolvedUrl);
        }
        catch (IOException e) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append(Messages.CouldNotResolvePath);
            logMsg.append(":");
            logMsg.append(" ");
            logMsg.append(pluginRelPath);
            logMsg.append(" ");
            logMsg.append(Messages.OfPlugin);
            logMsg.append(":");
            logMsg.append(" ");
            LOG.error((Object)logMsg.toString(), (Throwable)e);
        }
        return fileURL;
    }

    public static boolean isToolkitMoreConcrete(String level1, String level2) {
        int abstractness2;
        int abstractness1;
        String lvl1 = level1;
        String lvl2 = level2;
        if ("".equals(lvl1)) {
            lvl1 = "abstract";
        }
        if ("".equals(lvl2)) {
            lvl1 = "abstract";
        }
        return (abstractness1 = abstractness.get(lvl1).intValue()) > (abstractness2 = abstractness.get(lvl2).intValue());
    }

    public static String getToolkitName(String toolkitId) {
        List toolkitPluginDescriptors = ComponentBuilder.getInstance().getCompSystem().getAllToolkitPluginDescriptors();
        for (ToolkitPluginDescriptor desc : toolkitPluginDescriptors) {
            if (!desc.getToolkitID().equalsIgnoreCase(toolkitId)) continue;
            return desc.getName();
        }
        return toolkitId;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean doesToolkitInclude(String toolkitId, String includedToolkitId) {
        compSys = ComponentBuilder.getInstance().getCompSystem();
        desc = compSys.getToolkitPluginDescriptor(toolkitId);
        includes = desc.getIncludes();
        if (includes == null || !includes.equals(includedToolkitId)) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            desc = compSys.getToolkitPluginDescriptor(includes);
            if (desc == null || (includes = desc.getIncludes()) == null || !includes.equals(includedToolkitId)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (desc != null && includes != null && !"null".equals((Object)includes))
        }
lbl10:
        // 1 sources

        return false;
    }

    public static Composite createAutConfigComponent(String className, ClassLoader classLoader, Composite parent, int style, Map<String, String> autConfig, String autName) throws ToolkitPluginException {
        Composite autConfigDialog = null;
        StringBuilder logMsg = new StringBuilder();
        logMsg.append(Messages.FailedLoading);
        logMsg.append("/");
        logMsg.append(Messages.InstantiatingClass);
        logMsg.append(":");
        logMsg.append(" ");
        try {
            Class<?> autConfigComponentClass = classLoader.loadClass(className);
            Constructor<?> constructor = autConfigComponentClass.getConstructor(Composite.class, Integer.TYPE, Map.class, String.class);
            autConfigDialog = (Composite)constructor.newInstance(parent, style, autConfig, autName);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e);
            throw new ToolkitPluginException(String.valueOf(logMsg.toString()) + String.valueOf(className), e);
        }
        return autConfigDialog;
    }
}

