/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.provider.swt.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.core.utils.LocaleUtil;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.JavaAutConfigComponent;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtAutConfigComponent
extends JavaAutConfigComponent {
    public static final String KEYBOARD_LAYOUT = "KEYBOARD_LAYOUT";
    private DirectCombo<Locale> m_keyboardLayoutCombo;

    public SwtAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName);
    }

    protected void createAdvancedArea(Composite advancedAreaComposite) {
        super.createAdvancedArea(advancedAreaComposite);
        List langList = Languages.getInstance().getSuppLangList();
        ArrayList<String> strLangList = new ArrayList<String>(langList.size());
        for (Locale locale : langList) {
            strLangList.add(locale.getDisplayName(Locale.getDefault()));
        }
        UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)I18n.getString((String)"SwtAutConfigComponent.KEYBOARD_LAYOUT"));
        this.m_keyboardLayoutCombo = new DirectCombo(advancedAreaComposite, 8, langList, strLangList, false, true);
        GridData comboGrid = new GridData(4, 2, true, false, 2, 1);
        Layout.addToolTipAndMaxWidth((GridData)comboGrid, this.m_keyboardLayoutCombo);
        this.m_keyboardLayoutCombo.setLayoutData((Object)comboGrid);
        ((GridData)this.m_keyboardLayoutCombo.getLayoutData()).widthHint = 250;
        String keyboardLayout = this.getConfigValue(KEYBOARD_LAYOUT);
        if (keyboardLayout == null || keyboardLayout.length() == 0) {
            this.m_keyboardLayoutCombo.setSelectedObject((Object)Locale.getDefault());
        } else {
            this.m_keyboardLayoutCombo.setSelectedObject((Object)LocaleUtil.convertStrToLocale((String)keyboardLayout));
        }
        this.m_keyboardLayoutCombo.addModifyListener((ModifyListener)new KeyboardLayoutComboListener());
    }

    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyKeyboardLayout());
    }

    DialogStatusParameter modifyKeyboardLayout() {
        Locale locale = (Locale)this.m_keyboardLayoutCombo.getSelectedObject();
        if (locale != null) {
            this.putConfigValue(KEYBOARD_LAYOUT, locale.toString());
        }
        return null;
    }

    protected class KeyboardLayoutComboListener
    implements ModifyListener {
        protected KeyboardLayoutComboListener() {
        }

        public void modifyText(ModifyEvent e) {
            SwtAutConfigComponent.this.checkAll();
        }
    }
}

